/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.common.print.pdf.printer.expert;

import ch.dvbern.tax.common.presentation.common.print.pdf.printer.ItemPrinter;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.ItemPrinterFactory;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.expert.TableAdditionItem;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.expert.TablePrinter;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.LocalizationHelper;
import ch.dvbern.tax.common.transfer.failure.FormRendererException;
import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PatternColor;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfPatternPainter;
import java.awt.Color;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;

public class TableAdditionPrinter
extends TablePrinter {
    @Override
    protected void initalize( @NonNull ExpertDisplayInfoDTO.ItemDTO item) {
        TableAdditionItem tableItem = (TableAdditionItem)item;
        super.initalize(tableItem.getTable());
        this.rowNo = tableItem.getNextRow();
    }

    @Override
    protected void printStandardTable(float xOffset, float yOffset) throws FormRendererException {
        try {
            int start;
            ExpertDisplayInfoDTO.TableDTO tableDTO = this.item;
            int colCnt = 0;
            for (ExpertDisplayInfoDTO.TableDTO.ColumnDTO element : tableDTO.getPrintColumns()) {
                ExpertDisplayInfoDTO.TableDTO.ColumnDTO col = element;
                if (!this.isPrintColumn(col)) continue;
                ++colCnt;
            }
            Font titleFont = this.itextFont(tableDTO.getTitleFont());
            PdfPTable table = new PdfPTable(colCnt);
            table.setWidthPercentage(100.0f);
            table.setHeaderRows(2);
            table.setSpacingBefore(12.0f);
            Paragraph title = new Paragraph(this.getGlobalConverterContext().getLocalizationHelper().translate(tableDTO.getTitle(), new Object[0]), titleFont);
            PdfPCell cellTitle = new PdfPCell((Phrase)title);
            if (tableDTO.getTitlePattern() != null) {
                ExpertDisplayInfoDTO.PatternDTO pattern = tableDTO.getTitlePattern();
                PdfPatternPainter pat = this.getDirectContent().createPattern(pattern.getDistance(), pattern.getDistance(), TableAdditionPrinter.awtColor(pattern.getColor()));
                pat.rectangle(pattern.getSize(), pattern.getSize(), pattern.getSize(), pattern.getSize());
                pat.fill();
                cellTitle.setBackgroundColor((Color)new PatternColor(pat));
            }
            cellTitle.setColspan(colCnt);
            cellTitle.setBorderColor(TableAdditionPrinter.awtColor(tableDTO.getBorderColor()));
            table.addCell(cellTitle);
            float[] colWidths = new float[colCnt];
            int j = 0;
            for (ExpertDisplayInfoDTO.TableDTO.ColumnDTO element : tableDTO.getPrintColumns()) {
                ExpertDisplayInfoDTO.TableDTO.ColumnDTO col = element;
                if (!this.isPrintColumn(col)) continue;
                String colTitleTranslated = "";
                if (col.getTitle() != null) {
                    colTitleTranslated = this.getGlobalConverterContext().getLocalizationHelper().translate(col.getTitle(), new Object[0]);
                }
                Chunk colTitle = new Chunk(colTitleTranslated);
                colTitle.setFont(this.itextFont(col.getFont()));
                colTitle.setHyphenation(this.getDocumentContext().getHyphenation());
                PdfPCell cell = new PdfPCell(new Phrase(colTitle));
                cell.setBorderColor(TableAdditionPrinter.awtColor(tableDTO.getBorderColor()));
                cell.setHorizontalAlignment(col.getAlignment());
                table.addCell(cell);
                colWidths[j++] = (float)col.getWidth() / (float)tableDTO.getWidth();
            }
            table.setWidths(colWidths);
            for (int i = start = this.rowNo; i < tableDTO.getPrintRows().size(); ++i) {
                ExpertDisplayInfoDTO.TableDTO.RowDTO row = tableDTO.getPrintRows().get(i);
                int colNo = 0;
                for (ExpertDisplayInfoDTO.TableDTO.ColumnDTO col : tableDTO.getPrintColumns()) {
                    if (!this.isPrintColumn(col) || colNo >= row.getValues().size()) continue;
                    ExpertDisplayInfoDTO.TableDTO.CellDTO cell = (ExpertDisplayInfoDTO.TableDTO.CellDTO)row.getValues().get(colNo);
                    Chunk ck = new Chunk(this.getText(col, cell));
                    ck.setFont(this.itextFont(cell.getFont()));
                    PdfPCell pdfCell = new PdfPCell(new Phrase(ck));
                    pdfCell.setBorderColor(TableAdditionPrinter.awtColor(tableDTO.getBorderColor()));
                    pdfCell.setPaddingTop(tableDTO.getExtraPagesRowPadding());
                    pdfCell.setHorizontalAlignment(TableAdditionPrinter.itextAlignment(col.getAlignment()));
                    table.addCell(pdfCell);
                    ++colNo;
                }
            }
            this.getDocumentContext().getDocument().add((Element)table);
        }
        catch (LocalizationHelper.LocalizationHelperException e) {
            throw new FormRendererException("can't print additional table", e);
        }
        catch (DocumentException e) {
            throw new FormRendererException("can't print additional table", e);
        }
    }

    @Override
    protected void printEnhancedTable() throws FormRendererException {
        ItemPrinterFactory printerFactory = new ItemPrinterFactory(this.getDocumentContext());
        List<ExpertDisplayInfoDTO.TableDTO.RowDTO> rows = this.item.getPrintRows();
        int firstRow = this.rowNo;
        while (this.rowNo < rows.size() && this.rowNo - firstRow < this.item.getExtraPagesFormRows()) {
            ExpertDisplayInfoDTO.TableDTO.RowDTO row = rows.get(this.rowNo);
            for (Object element : row.getValues()) {
                ExpertDisplayInfoDTO.ItemDTO rowItem = (ExpertDisplayInfoDTO.ItemDTO)element;
                ItemPrinter<ExpertDisplayInfoDTO.ItemDTO> printer = printerFactory.getPrinter(rowItem);
                printer.print(this.item.getX() + (int)this.item.getExtraPagesPrintOffsetX(), (float)(this.item.getY() + (int)this.item.getExtraPagesPrintOffsetY() + this.item.getHeaderHeight()) + (float)(this.rowNo - firstRow) * this.item.getRowHeight());
            }
            ++this.rowNo;
        }
        if (this.rowNo < rows.size() && this.rowNo < this.item.getEndRow()) {
            this.addExtraItem(new TableAdditionItem(this.item, this.rowNo));
        }
    }

    private boolean isPrintColumn(ExpertDisplayInfoDTO.TableDTO.ColumnDTO col) {
        return col.getPrintMode() != 1 && col.getPrintMode() != 0;
    }
}

