/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.common.print.pdf.printer;

import ch.dvbern.tax.common.presentation.common.print.pdf.DocumentContext;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.ItemPrinter;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.expert.Barcode1DPrinter;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.expert.Barcode2DAdditionItem;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.expert.Barcode2DPrinter;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.expert.CustomPrinter;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.expert.ExpertItemPrinter;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.expert.GridTablePrinter;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.expert.ImagePrinter;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.expert.ListAdditionItem;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.expert.ListAdditionPrinter;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.expert.ListPrinter;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.expert.RectanglePrinter;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.expert.TableAdditionItem;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.expert.TableAdditionPrinter;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.expert.TablePrinter;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.expert.Template;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.expert.TemplatePrinter;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.expert.TextPrinter;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.wizard.BrPrinter;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.wizard.ButtonPrinter;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.wizard.LabelPrinter;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.wizard.LinkPrinter;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.wizard.SectionPrinter;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.wizard.WizardItemPrinter;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.wizard.WizardTablePrinter;
import ch.dvbern.tax.common.transfer.dto.CustomPrinterDTO;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.WizardDisplayInfoDTO;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ItemPrinterFactory {
    private final DocumentContext ctx;
    private static final Map<Class<? extends ExpertDisplayInfoDTO.ItemDTO>, ItemPrinter<? extends ExpertDisplayInfoDTO.ItemDTO>> expertPrinters = new ConcurrentHashMap<Class<? extends ExpertDisplayInfoDTO.ItemDTO>, ItemPrinter<? extends ExpertDisplayInfoDTO.ItemDTO>>();
    private static final Map<Class<? extends WizardDisplayInfoDTO.AbstractItemDTO>, ItemPrinter<? extends WizardDisplayInfoDTO.AbstractItemDTO>> wizardPrinters = new ConcurrentHashMap<Class<? extends WizardDisplayInfoDTO.AbstractItemDTO>, ItemPrinter<? extends WizardDisplayInfoDTO.AbstractItemDTO>>();

    public ItemPrinterFactory(DocumentContext ctx) {
        this.ctx = ctx;
    }

    public static void putExpertPrinter(@NonNull Class<? extends ExpertDisplayInfoDTO.ItemDTO> item, @NonNull ItemPrinter<? extends ExpertDisplayInfoDTO.ItemDTO> printer) {
        expertPrinters.put(item, printer);
    }

    public ItemPrinter<ExpertDisplayInfoDTO.ItemDTO> getPrinter(ExpertDisplayInfoDTO.ItemDTO item) {
        ExpertItemPrinter<ExpertDisplayInfoDTO.ItemDTO> printer = this.findPrinter(item);
        printer.initalize(this.ctx, item);
        return printer;
    }

    public ItemPrinter<WizardDisplayInfoDTO.AbstractItemDTO> getPrinter(WizardDisplayInfoDTO.AbstractItemDTO item) {
        WizardItemPrinter<WizardDisplayInfoDTO.AbstractItemDTO> printer = this.findPrinter(item);
        printer.initalize(this.ctx, item);
        return printer;
    }

    private ExpertItemPrinter<ExpertDisplayInfoDTO.ItemDTO> findPrinter(ExpertDisplayInfoDTO.ItemDTO item) {
        ExpertItemPrinter printer = (ExpertItemPrinter)expertPrinters.get(item.getClass());
        if (printer != null) {
            return printer;
        }
        throw new IllegalArgumentException("no ItemPrinter available for item class: " + String.valueOf(item));
    }

    private WizardItemPrinter<WizardDisplayInfoDTO.AbstractItemDTO> findPrinter(WizardDisplayInfoDTO.AbstractItemDTO item) {
        WizardItemPrinter wizardItemPrinter = (WizardItemPrinter)wizardPrinters.get(item.getClass());
        if (wizardItemPrinter != null) {
            return wizardItemPrinter;
        }
        throw new IllegalArgumentException("no ItemPrinter available for item class: " + String.valueOf(item));
    }

    static {
        expertPrinters.put(ExpertDisplayInfoDTO.Barcode1DDTO.class, new Barcode1DPrinter());
        expertPrinters.put(ExpertDisplayInfoDTO.ImageDTO.class, new ImagePrinter());
        expertPrinters.put(ExpertDisplayInfoDTO.ValueItemDTO.class, new TextPrinter(false));
        expertPrinters.put(ExpertDisplayInfoDTO.LabelDTO.class, new TextPrinter(true));
        expertPrinters.put(ExpertDisplayInfoDTO.TableDTO.class, new TablePrinter());
        expertPrinters.put(ExpertDisplayInfoDTO.TableGridDTO.class, new GridTablePrinter());
        expertPrinters.put(TableAdditionItem.class, new TableAdditionPrinter());
        expertPrinters.put(ExpertDisplayInfoDTO.Barcode2DContainerDTO.class, new Barcode2DPrinter());
        expertPrinters.put(Barcode2DAdditionItem.class, new Barcode2DPrinter());
        expertPrinters.put(ExpertDisplayInfoDTO.RectangleDTO.class, new RectanglePrinter());
        expertPrinters.put(ExpertDisplayInfoDTO.ListDTO.class, new ListPrinter());
        expertPrinters.put(ListAdditionItem.class, new ListAdditionPrinter());
        expertPrinters.put(Template.class, new TemplatePrinter());
        expertPrinters.put(CustomPrinterDTO.class, new CustomPrinter());
        wizardPrinters.put(WizardDisplayInfoDTO.BRItemDTO.class, new BrPrinter());
        wizardPrinters.put(WizardDisplayInfoDTO.ButtonDTO.class, new ButtonPrinter());
        wizardPrinters.put(WizardDisplayInfoDTO.LinkItemDTO.class, new LinkPrinter());
        wizardPrinters.put(WizardDisplayInfoDTO.LabelItemDTO.class, new LabelPrinter());
        wizardPrinters.put(WizardDisplayInfoDTO.SectionItemDTO.class, new SectionPrinter());
        wizardPrinters.put(WizardDisplayInfoDTO.TableItemDTO.class, new WizardTablePrinter());
    }
}

