/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.common.print.pdf;

import ch.dvbern.tax.common.integration.conf.ApplicationConfig;
import ch.dvbern.tax.common.presentation.common.print.FormRenderer;
import ch.dvbern.tax.common.presentation.common.print.FormRendererConfiguration;
import ch.dvbern.tax.common.presentation.common.print.pdf.DocumentContext;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.ItemPrinter;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.ItemPrinterFactory;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.expert.Template;
import ch.dvbern.tax.common.presentation.common.util.ImageSource;
import ch.dvbern.tax.common.transfer.dto.DisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.LocalizationHelper;
import ch.dvbern.tax.common.transfer.dto.WizardDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.failure.FormRendererException;
import ch.dvbern.tax.common.transfer.util.WizardLabelAddOnHelper;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDestination;
import com.lowagie.text.pdf.PdfOutline;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfPageEventHelper;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PdfFormRenderer
extends FormRenderer {
    private static final int WATERMARK_FONT_SIZE = 32;
    private ItemPrinterFactory printerFactory = null;
    private DocumentContext documentContext = null;
    private String watermark = null;
    private boolean printOutline;
    private boolean reverseWatermarkOverText = false;

    public PdfFormRenderer(FormRendererConfiguration configuration,  @NonNull AbstractConverter.ConverterContext converterContext, ImageSource imgSource) {
        super(configuration, converterContext, imgSource);
    }

    @Override
    public void render(List<? extends DisplayInfoDTO> forms, OutputStream os) throws FormRendererException, InterruptedException {
        if (forms == null) {
            throw new NullPointerException("Forms list cannot be null.");
        }
        if (os == null) {
            throw new NullPointerException("Output stream cannot be null.");
        }
        FormRendererConfiguration configuration = this.getConfiguration();
        try {
            Document document = new Document();
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)os);
            if (configuration.isOpenOutlineByDefault()) {
                writer.setViewerPreferences(128);
            }
            writer.setCloseStream(false);
            this.documentContext = new DocumentContext(document, writer, this.getConverterContext(), this.getImageSource(), configuration);
            this.printerFactory = new ItemPrinterFactory(this.documentContext);
            int i = 0;
            for (DisplayInfoDTO displayInfoDTO : forms) {
                this.handleInterrupted();
                if (displayInfoDTO instanceof ExpertDisplayInfoDTO) {
                    String name = ((ExpertDisplayInfoDTO)displayInfoDTO).getName();
                    boolean isBarcodePage = name.equals("Barcode");
                    this.watermark = configuration.isCopyWatermark() && !isBarcodePage ? this.getConverterContext().getLocalizationHelper().translate("label.print.kopie", new Object[0]) : configuration.getWatermark();
                    this.reverseWatermarkOverText = ((ExpertDisplayInfoDTO)displayInfoDTO).isReverseWatermarkOverText();
                    this.printOutline = configuration.isPrintOutline();
                    this.render(document, writer, (ExpertDisplayInfoDTO)displayInfoDTO);
                } else if (displayInfoDTO instanceof WizardDisplayInfoDTO) {
                    this.watermark = null;
                    this.printOutline = false;
                    WizardDisplayInfoDTO.FormItemDTO formItem = ((WizardDisplayInfoDTO)displayInfoDTO).getFormItemDTO();
                    ExpertDisplayInfoDTO wizardBackground = configuration.getWizardBackground();
                    if (wizardBackground != null && formItem.getPrintState() < 10) {
                        this.render(document, writer, wizardBackground);
                    }
                    this.render(document, (WizardDisplayInfoDTO)displayInfoDTO);
                } else {
                    throw new FormRendererException("Invalid form type: " + String.valueOf(displayInfoDTO.getClass()));
                }
                this.notifyProgressListeners(i++);
            }
            for (Template template : this.documentContext.getTemplates()) {
                this.printerFactory.getPrinter(template).print();
            }
            document.close();
            writer.close();
        }
        catch (LocalizationHelper.LocalizationHelperException | DocumentException e) {
            throw new FormRendererException("pdf printing failed", e);
        }
    }

    private void render(final Document document, final PdfWriter writer, final ExpertDisplayInfoDTO form) throws FormRendererException {
        ExpertDisplayInfoDTO.NavigationDTO navigationDTO;
        Map<String, PdfOutline> outlines;
        ExpertDisplayInfoDTO.PageSettingsDTO page = form.getPageSize();
        this.sizeDocumentNextPages(document, page);
        this.documentContext.setValuePaddingX(form.getValuePrintPaddingX());
        this.documentContext.setValuePaddingY(form.getValuePrintPaddingY());
        writer.setPageEvent(null);
        if (!document.isOpen()) {
            document.open();
        } else {
            document.newPage();
        }
        this.documentContext.setFormPage(1);
        this.documentContext.setFormPages(1);
        this.documentContext.setPageSettings(page);
        String accessKey = form.getAccessKey();
        if (this.printOutline && !(outlines = this.documentContext.getOutlines()).containsKey(accessKey) && (navigationDTO = this.retrieveNavigationDTO(form.getNavigationItems(), accessKey)) != null) {
            this.processOutline(outlines, writer, navigationDTO);
        }
        this.printWatermark(document, writer);
        ExpertDisplayInfoDTO.ImageDTO image = form.getPrintBackground();
        if (image != null) {
            this.printerFactory.getPrinter(image).print();
        }
        final List<ExpertDisplayInfoDTO.ItemDTO> items = form.getItems();
        writer.setPageEvent((PdfPageEvent)new PdfPageEventHelper(){

            public void onStartPage(PdfWriter w, Document doc) {
                try {
                    PdfFormRenderer.this.documentContext.setFormPage(PdfFormRenderer.this.documentContext.getFormPage() + 1);
                    PdfFormRenderer.this.printWatermark(document, writer);
                    ExpertDisplayInfoDTO.ImageDTO extraBackground = form.getExtraPagesBackground();
                    if (extraBackground != null) {
                        PdfFormRenderer.this.printerFactory.getPrinter(extraBackground).print();
                    }
                    PdfFormRenderer.this.printItems(items, 12);
                }
                catch (FormRendererException e) {
                    throw new RuntimeException("can't print page header", e);
                }
            }

            public void onEndPage(PdfWriter w, Document doc) {
            }
        });
        this.printItems(items, 9);
        this.sizeDocumentNextPages(document, form.getExtraPagesSize());
        while (!this.documentContext.getExtraItems().isEmpty()) {
            document.newPage();
            ArrayList<ExpertDisplayInfoDTO.ItemDTO> toPrint = new ArrayList<ExpertDisplayInfoDTO.ItemDTO>();
            toPrint.addAll(this.documentContext.getExtraItems());
            this.documentContext.getExtraItems().clear();
            this.printItems(toPrint, -1);
        }
        this.printItems(form.getItems(), 2);
    }

    private void sizeDocumentNextPages(Document document, ExpertDisplayInfoDTO.PageSettingsDTO pageSettings) {
        document.setPageSize(new Rectangle((float)pageSettings.getWidth(), (float)pageSettings.getHeight()));
        document.setMargins(pageSettings.getMarginLeft() > 0 ? (float)pageSettings.getMarginLeft() : document.leftMargin(), pageSettings.getMarginRight() > 0 ? (float)pageSettings.getMarginRight() : document.rightMargin(), pageSettings.getMarginTop() > 0 ? (float)pageSettings.getMarginTop() : document.topMargin(), pageSettings.getMarginBottom() > 0 ? (float)pageSettings.getMarginBottom() : document.bottomMargin());
    }

    private PdfOutline processOutline(Map<String, PdfOutline> outlines, PdfWriter writer, ExpertDisplayInfoDTO.NavigationDTO navigationDTO) throws FormRendererException {
        String accessKey = navigationDTO.getAccessKey();
        PdfOutline outline = outlines.get(accessKey);
        if (outline != null) {
            return outline;
        }
        ExpertDisplayInfoDTO.NavigationDTO parentNavigationDTO = navigationDTO.getParent();
        PdfContentByte cb = writer.getDirectContent();
        PdfOutline parentOutline = parentNavigationDTO == null ? cb.getRootOutline() : this.processOutline(outlines, writer, parentNavigationDTO);
        String descriptionKey = navigationDTO.getDescriptionKey();
        if (descriptionKey == null) {
            outline = parentOutline;
        } else {
            String description;
            try {
                List<ExpertDisplayInfoDTO.LabelDTO.LabelAddOnDTO> addOns = navigationDTO.getDesciptionAddOns();
                description = this.getConverterContext().getLocalizationHelper().translate(navigationDTO.getDescriptionKey(), addOns != null ? addOns.toArray() : null);
            }
            catch (LocalizationHelper.LocalizationHelperException e) {
                throw new FormRendererException("Failed to translate form description.", e);
            }
            int crtPage = writer.getCurrentPageNumber();
            outline = new PdfOutline(parentOutline, PdfAction.gotoLocalPage((int)crtPage, (PdfDestination)new PdfDestination(crtPage), (PdfWriter)writer), description);
        }
        outlines.put(accessKey, outline);
        return outline;
    }

    private @Nullable ExpertDisplayInfoDTO.NavigationDTO retrieveNavigationDTO(@NonNull List<ExpertDisplayInfoDTO.NavigationDTO> navigationItems, @NonNull String accessKey) {
        assert (accessKey != null);
        assert (navigationItems != null);
        for (ExpertDisplayInfoDTO.NavigationDTO item : navigationItems) {
            ExpertDisplayInfoDTO.NavigationDTO result;
            if (item.getAccessKey().equals(accessKey)) {
                return item;
            }
            List<ExpertDisplayInfoDTO.NavigationDTO> subItems = item.getSubItems();
            if (subItems == null || (result = this.retrieveNavigationDTO(subItems, accessKey)) == null) continue;
            return result;
        }
        return null;
    }

    private void render(Document document, WizardDisplayInfoDTO form) throws FormRendererException {
        WizardDisplayInfoDTO.FormItemDTO formItem = form.getFormItemDTO();
        if (formItem.getPrintState() > 10) {
            return;
        }
        this.printTitle(document, formItem);
        List<WizardDisplayInfoDTO.AbstractItemDTO> items = formItem.getChildren();
        if (items == null) {
            return;
        }
        for (WizardDisplayInfoDTO.AbstractItemDTO obj : items) {
            WizardDisplayInfoDTO.AbstractItemDTO item = obj;
            if (12 == item.getState()) continue;
            ItemPrinter<WizardDisplayInfoDTO.AbstractItemDTO> printer = this.printerFactory.getPrinter(item);
            printer.print(0.0f, 0.0f);
        }
    }

    private void printTitle(Document document, WizardDisplayInfoDTO.FormItemDTO formItem) throws FormRendererException {
        try {
            String titleKey = formItem.getHeader();
            if (titleKey != null) {
                Object[] args = WizardLabelAddOnHelper.getReplacements(formItem.getLabelAddOns(), this.getConverterContext());
                String title = this.getConverterContext().getLocalizationHelper().translate(titleKey, args);
                BaseFont bf = BaseFont.createFont((String)"Helvetica", (String)"Cp1252", (boolean)true);
                Font f = new Font(bf, 14.0f, 1);
                Paragraph p = new Paragraph(title, f);
                PdfPCell cell = new PdfPCell((Phrase)p);
                cell.setPaddingBottom(5.0f);
                cell.setBackgroundColor(Color.LIGHT_GRAY);
                PdfPTable table = new PdfPTable(1);
                table.setWidthPercentage(100.0f);
                table.addCell(cell);
                table.setSpacingAfter(12.0f);
                if (!document.isOpen()) {
                    document.open();
                }
                document.add((Element)table);
            }
        }
        catch (LocalizationHelper.LocalizationHelperException e) {
            throw new FormRendererException("can't translate title", e);
        }
        catch (IOException e) {
            throw new FormRendererException("title printing failed", e);
        }
    }

    private void printItems(Collection<ExpertDisplayInfoDTO.ItemDTO> items, int mode) throws FormRendererException {
        for (ExpertDisplayInfoDTO.ItemDTO item : items) {
            if (mode >= 0 && (item.getPrintMode() & mode) == 0) continue;
            ItemPrinter<ExpertDisplayInfoDTO.ItemDTO> printer = this.printerFactory.getPrinter(item);
            printer.print(0.0f, 0.0f);
        }
    }

    private void printWatermark(Document document, PdfWriter writer) throws FormRendererException {
        if (this.watermark == null || this.watermark.length() < 1) {
            return;
        }
        try {
            BaseFont bf = BaseFont.createFont((String)"Helvetica", (String)"Cp1252", (boolean)true);
            Boolean isWatermarkOverText = ApplicationConfig.getInstance().isPrintWatermarkOverText();
            if (this.reverseWatermarkOverText) {
                isWatermarkOverText = isWatermarkOverText == false;
            }
            PdfContentByte content = isWatermarkOverText != false ? writer.getDirectContent() : writer.getDirectContentUnder();
            content.saveState();
            content.setGrayFill(0.7f);
            content.beginText();
            content.setFontAndSize(bf, 32.0f);
            Rectangle pageSize = document.getPageSize();
            content.showTextAligned(1, this.watermark, pageSize.getWidth() / 2.0f, pageSize.getHeight() / 2.0f, 45.0f);
            content.endText();
            content.restoreState();
        }
        catch (DocumentException | IOException e) {
            throw new FormRendererException("can't print watermark", e);
        }
    }

    private void handleInterrupted() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException("Current thread interrupted.");
        }
    }
}

