/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.common.print;

import ch.dvbern.tax.common.presentation.common.Mode;
import ch.dvbern.tax.common.presentation.common.print.FormKey;
import ch.dvbern.tax.common.presentation.common.print.FormRendererConfiguration;
import ch.dvbern.tax.common.presentation.common.print.ProgressListener;
import ch.dvbern.tax.common.presentation.common.util.ImageSource;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PrintRequest {
    private @NonNull AbstractConverter.ConverterContext ctx;
    private final @NonNull ImageSource imageSource;
    private @Nullable ProgressListener progressListener;
    private @Nullable FormRendererConfiguration configuration;
    private @NonNull List<FormKey> formKeys = new ArrayList<FormKey>();

    public PrintRequest(@NonNull AbstractConverter.ConverterContext ctx, @NonNull ImageSource imageSource) {
        if (ctx == null) {
            throw new NullPointerException("ConverterContext cannot be null.");
        }
        if (imageSource == null) {
            throw new NullPointerException("Image source instance cannot be null.");
        }
        this.ctx = ctx;
        this.imageSource = imageSource;
    }

    public @NonNull AbstractConverter.ConverterContext getConverterContext() {
        return this.ctx;
    }

    public @NonNull ImageSource getImageSource() {
        return this.imageSource;
    }

    public @NonNull FormRendererConfiguration getConfiguration() {
        return this.configuration == null ? (this.configuration = new FormRendererConfiguration()) : this.configuration;
    }

    public @NonNull PrintRequest withConfiguration(FormRendererConfiguration configuration) {
        this.configuration = configuration;
        return this;
    }

    public @NonNull PrintRequest withExpertKeys(@NonNull Collection<String> keys) {
        if (keys == null) {
            throw new NullPointerException("Keys cannot be null.");
        }
        for (String key : keys) {
            this.formKeys.add(new FormKey(key, Mode.EXPERT));
        }
        return this;
    }

    public @NonNull PrintRequest withExpertKeys(String ... keys) {
        if (keys == null) {
            throw new NullPointerException("Keys cannot be null.");
        }
        this.withExpertKeys(Arrays.asList(keys));
        return this;
    }

    public @NonNull PrintRequest withWizardKeys(@NonNull Collection<String> keys) {
        if (keys == null) {
            throw new NullPointerException("Keys cannot be null.");
        }
        for (String key : keys) {
            this.formKeys.add(new FormKey(key, Mode.WIZARD));
        }
        return this;
    }

    public @NonNull PrintRequest withWizardKeys(String ... keys) {
        if (keys == null) {
            throw new NullPointerException("Keys cannot be null.");
        }
        this.withExpertKeys(Arrays.asList(keys));
        return this;
    }

    public @NonNull PrintRequest withFormKeys(@NonNull Collection<FormKey> keys) {
        if (keys == null) {
            throw new NullPointerException("Keys cannot be null.");
        }
        for (FormKey key : keys) {
            if (key == null) {
                throw new NullPointerException("Null key not permitted.");
            }
            this.formKeys.add(key);
        }
        return this;
    }

    public @NonNull PrintRequest withFormKeys(FormKey ... keys) {
        if (keys == null) {
            throw new NullPointerException("Keys cannot be null.");
        }
        this.withFormKeys(Arrays.asList(keys));
        return this;
    }

    public @NonNull PrintRequest withProgressListener(@Nullable ProgressListener progressListener) {
        this.progressListener = progressListener;
        return this;
    }

    public @Nullable ProgressListener getProgressListener() {
        return this.progressListener;
    }

    public @NonNull List<FormKey> getFormKeys() {
        return this.formKeys;
    }
}

