/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.common.print;

import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class FormRendererUtil {
    private static String applicationVersion = null;

    private FormRendererUtil() {
    }

    public static @Nullable String getText(ExpertDisplayInfoDTO.TextItemDTO item, @NonNull AbstractConverter.ConverterContext ctx) {
        if (item instanceof ExpertDisplayInfoDTO.LabelDTO) {
            return FormRendererUtil.getText((ExpertDisplayInfoDTO.LabelDTO)item, ctx);
        }
        if (item instanceof ExpertDisplayInfoDTO.ValueItemDTO) {
            return FormRendererUtil.getText((ExpertDisplayInfoDTO.ValueItemDTO)item, ctx);
        }
        throw new IllegalArgumentException("don't know what to do with " + String.valueOf(item));
    }

    private static @Nullable String getText(ExpertDisplayInfoDTO.LabelDTO label, @NonNull AbstractConverter.ConverterContext ctx) {
        return label.getText(ctx);
    }

    private static @Nullable String getText(ExpertDisplayInfoDTO.ValueItemDTO item, @NonNull AbstractConverter.ConverterContext ctx) {
        Object value = null;
        if (item.getModelItem() != null && item.getModelItem().getState() != 12) {
            value = item.getModelItem().getValue();
        }
        return item.getRendererAndInputValidator().getRenderedValueToPrint(value, item.isReadonly(), item.getOptionItems(), ctx.withDmk(item.getDataModelKey()));
    }

    public static @Nullable String getText(ExpertDisplayInfoDTO.TableDTO.ColumnDTO col, ExpertDisplayInfoDTO.TableDTO.CellDTO cell, @NonNull AbstractConverter.ConverterContext ctx) {
        if (cell instanceof ExpertDisplayInfoDTO.TableDTO.ValueCellDTO) {
            ExpertDisplayInfoDTO.TableDTO.ValueCellDTO valueCell = (ExpertDisplayInfoDTO.TableDTO.ValueCellDTO)cell;
            Object value = null;
            if (valueCell.getModelItem() != null) {
                value = valueCell.getModelItem().getValue();
            }
            return col.getRendererAndInputValidator().getRenderedValueToPrint(value, col.isReadonly(), valueCell.getOptionItems(), ctx.withDmk(valueCell.getDataModelKey()));
        }
        if (cell instanceof ExpertDisplayInfoDTO.TableDTO.LabelCellDTO) {
            ExpertDisplayInfoDTO.TableDTO.LabelCellDTO labelCell = (ExpertDisplayInfoDTO.TableDTO.LabelCellDTO)cell;
            return labelCell.getText(ctx);
        }
        return "";
    }

    public static @Nullable String getText(ExpertDisplayInfoDTO.ListDTO.RowDTO row, @NonNull AbstractConverter.ConverterContext ctx) {
        if (row instanceof ExpertDisplayInfoDTO.ListDTO.LabelRowDTO) {
            return FormRendererUtil.getText((ExpertDisplayInfoDTO.ListDTO.LabelRowDTO)row, ctx);
        }
        if (row instanceof ExpertDisplayInfoDTO.ListDTO.ValueRowDTO) {
            return FormRendererUtil.getText((ExpertDisplayInfoDTO.ListDTO.ValueRowDTO)row, ctx);
        }
        throw new IllegalArgumentException("don't know what to do with " + String.valueOf(row));
    }

    private static @Nullable String getText(ExpertDisplayInfoDTO.ListDTO.LabelRowDTO item, @NonNull AbstractConverter.ConverterContext ctx) {
        return item.getText(ctx);
    }

    private static @Nullable String getText(ExpertDisplayInfoDTO.ListDTO.ValueRowDTO item, @NonNull AbstractConverter.ConverterContext ctx) {
        AbstractConverter<?> converter = item.getConverter();
        Object value = null;
        if (item.getModelItem() != null && item.getModelItem().getState() != 11) {
            value = item.getModelItem().getValue();
        }
        return converter.getRenderedValueToPrint(value, true, item.getOptionItems(), ctx);
    }

    public static @NonNull String getApplicationVersion() {
        return applicationVersion == null ? "" : applicationVersion;
    }

    public static void setApplicationVersion(@Nullable String applicationVersion) {
        FormRendererUtil.applicationVersion = applicationVersion;
    }
}

