/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.common.print;

import ch.dvbern.tax.common.presentation.common.print.FormRenderer;
import ch.dvbern.tax.common.presentation.common.print.FormRendererConfiguration;
import ch.dvbern.tax.common.presentation.common.print.html.HtmlFormRenderer;
import ch.dvbern.tax.common.presentation.common.print.pdf.PdfFormRenderer;
import ch.dvbern.tax.common.presentation.common.util.ImageSource;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class FormRendererFactory {
    public static final int TYPE_PDF = 0;
    public static final int TYPE_HTML = 1;

    private FormRendererFactory() {
    }

    public static FormRenderer createRenderEngine(FormRendererConfiguration configuration, int type,  @NonNull AbstractConverter.ConverterContext ctx, ImageSource imgSource) {
        if (configuration == null) {
            throw new NullPointerException("configuration must not be null");
        }
        if (imgSource == null) {
            throw new NullPointerException("imgSource must not be null");
        }
        if (ctx == null) {
            throw new NullPointerException("ConverterContext must not be null");
        }
        switch (type) {
            case 1: {
                return new HtmlFormRenderer(configuration, ctx, imgSource);
            }
            case 0: {
                return new PdfFormRenderer(configuration, ctx, imgSource);
            }
        }
        throw new UnsupportedOperationException("Type " + type + " unknown.");
    }
}

