/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.integration.util;

import ch.dvbern.tax.common.integration.util.PasswordHelperException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Random;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;

public final class PasswordHelper {
    private static final char[] PASSWORD_CHARS = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'j', 'k', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private static final int PASSWORD_LENGTH = 10;
    private static final String CHARSET = "ISO-8859-1";
    private static Random random;

    private PasswordHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String generatePassword() {
        char[] password = new char[10];
        Random random = PasswordHelper.random;
        synchronized (random) {
            for (int i = 0; i < password.length; ++i) {
                password[i] = PASSWORD_CHARS[PasswordHelper.random.nextInt(PASSWORD_CHARS.length)];
            }
        }
        return new String(password);
    }

    public static String generateHash(String password) throws UnsupportedEncodingException {
        if (password == null) {
            throw new NullPointerException("password must not be null");
        }
        byte[] hashBytes = PasswordHelper.generateMessageDigest(password);
        return StringUtils.newStringUtf8((byte[])Base64.encodeBase64((byte[])hashBytes, (boolean)false, (boolean)false));
    }

    private static byte[] generateMessageDigest(String str) throws UnsupportedEncodingException {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            return md.digest(str.getBytes(CHARSET));
        }
        catch (NoSuchAlgorithmException e) {
            throw new PasswordHelperException("no SHA-1 implementation found", e);
        }
    }

    static {
        try {
            random = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            throw new PasswordHelperException("cannot create random number generator", e);
        }
    }
}

