/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.wizarddisplay.items;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.lib.resource.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayUtil;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.engine.wizarddisplay.WTableEntryAccessor;
import ch.dvbern.tax.common.engine.wizarddisplay.WizardDisplayModelItem;
import ch.dvbern.tax.common.engine.wizarddisplay.items.FormHeaderTemplateAddOn;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Help;
import ch.dvbern.tax.common.engine.wizarddisplay.items.LabelAddOn;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.dto.WizardDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.failure.InvalidModelItemKeyException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicInteger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Form
extends WizardDisplayModelItem
implements WTableEntryAccessor {
    private static final Logger LOG = LoggerFactory.getLogger(Form.class);
    private final String name;
    private final String header;
    private final Help help;
    private final List<LabelAddOn> headerAddOns;
    private final List<WizardDisplayModelItem> children;
    private List<String> touchItemKeyList;
    private List<String> printStateItems;
    private final String headerTemplate;
    private final List<FormHeaderTemplateAddOn> headerTemplateAddOns;
    private final boolean extraFrom;
    private final AtomicInteger nextOutputItemUniqueCounter = new AtomicInteger(Integer.MAX_VALUE);
    private final AtomicInteger nextInputItemUniqueCounter = new AtomicInteger(0);
    private final boolean autoSetFocus;

    public Form(String name, String header, Help help, List<LabelAddOn> headerAddOns, String touchItemKey, String printStateItemKeys, List<WizardDisplayModelItem> children, String headerTemplate, List<FormHeaderTemplateAddOn> headerTemplateAddOns, boolean extraFrom, boolean autoSetFocus) {
        StringTokenizer st;
        this.children = children;
        this.name = name;
        this.header = header;
        this.help = help;
        this.headerAddOns = headerAddOns;
        if (touchItemKey != null && !touchItemKey.isEmpty()) {
            this.touchItemKeyList = new ArrayList<String>();
            st = new StringTokenizer(touchItemKey, ",");
            while (st.hasMoreTokens()) {
                this.touchItemKeyList.add(st.nextToken().trim());
            }
        }
        if (printStateItemKeys != null && !printStateItemKeys.isEmpty()) {
            this.printStateItems = new ArrayList<String>();
            st = new StringTokenizer(printStateItemKeys, ",");
            while (st.hasMoreTokens()) {
                this.printStateItems.add(st.nextToken().trim());
            }
        }
        this.headerTemplate = headerTemplate;
        this.headerTemplateAddOns = headerTemplateAddOns;
        this.extraFrom = extraFrom;
        this.autoSetFocus = autoSetFocus;
    }

    public List<WizardDisplayModelItem> getChildren() {
        return this.children;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getHeader() {
        return this.header;
    }

    public boolean isExtraFrom() {
        return this.extraFrom;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public WizardDisplayInfoDTO.FormItemDTO getFormInfo(WizardDisplayModelItem.ProtectedMap dataModel, String key) {
        void var8_16;
        WizardDisplayInfoDTO.HelpItemDTO formInfo;
        dataModel.touch(key);
        if (this.touchItemKeyList != null) {
            for (String element : this.touchItemKeyList) {
                String touchItem = element.toString();
                dataModel.touch(EngineUtil.mergeModelKey(touchItem, key));
            }
        }
        int printState = 1;
        try {
            printState = this.calcState(this.printStateItems, dataModel, key);
        }
        catch (InvalidModelItemKeyException e) {
            LOG.warn("invalid printStateItem in " + this.getName());
            throw new RuntimeException(e);
        }
        ArrayList<WizardDisplayInfoDTO.LabelAddOnDTO> labelAddOnDTOs = new ArrayList<WizardDisplayInfoDTO.LabelAddOnDTO>();
        if (this.headerAddOns != null) {
            for (LabelAddOn element : this.headerAddOns) {
                WizardDisplayInfoDTO.LabelAddOnDTO formInfo2 = element.getFormInfo(dataModel, key);
                if (formInfo2 == null) continue;
                labelAddOnDTOs.add(formInfo2);
            }
        }
        if (labelAddOnDTOs.isEmpty()) {
            labelAddOnDTOs = null;
        }
        WizardDisplayInfoDTO.HelpItemDTO helpDTO = null;
        if (this.help != null && (formInfo = this.help.getFormInfo(dataModel, key)) != null) {
            helpDTO = formInfo;
        }
        ArrayList<WizardDisplayInfoDTO.AbstractItemDTO> childrenDTO = null;
        if (this.getChildren() != null) {
            childrenDTO = new ArrayList<WizardDisplayInfoDTO.AbstractItemDTO>();
            for (WizardDisplayModelItem wizardDisplayModelItem : this.getChildren()) {
                WizardDisplayInfoDTO.AbstractItemDTO childDTO = (WizardDisplayInfoDTO.AbstractItemDTO)wizardDisplayModelItem.getFormInfo(dataModel, key);
                if (childDTO == null) continue;
                childrenDTO.add(childDTO);
            }
            if (childrenDTO.isEmpty()) {
                childrenDTO = null;
            }
        }
        ArrayList<WizardDisplayInfoDTO.FormHeaderTemplateAddOnDTO> headerTemplateAddOnDTOs = new ArrayList<WizardDisplayInfoDTO.FormHeaderTemplateAddOnDTO>();
        if (this.headerTemplateAddOns != null) {
            for (FormHeaderTemplateAddOn templateAddon : this.headerTemplateAddOns) {
                WizardDisplayInfoDTO.FormHeaderTemplateAddOnDTO formInfo3 = templateAddon.getFormInfo(dataModel, key);
                if (formInfo3 == null) continue;
                headerTemplateAddOnDTOs.add(formInfo3);
            }
        }
        if (headerTemplateAddOnDTOs.isEmpty()) {
            headerTemplateAddOnDTOs = null;
        }
        String string = key;
        if (EngineUtil.endsWithTableIndex(key)) {
            String string3 = EngineUtil.removeLastKeyPart(string);
            string3 = EngineUtil.removeLastKeyPart(string3);
        }
        WizardDisplayInfoDTO.FormItemDTO formItem = new WizardDisplayInfoDTO.FormItemDTO(this.getUniqueItemIdentifier(), 1, printState, this.name, this.header, helpDTO, labelAddOnDTOs, childrenDTO, (String)var8_16, this.headerTemplate, headerTemplateAddOnDTOs, this.autoSetFocus);
        return formItem;
    }

    @Override
    public void additionalInitializeWizardDisplayModel(Map<String, LogicModelItem> logicModelItems) throws InvalidModelException {
        if (this.touchItemKeyList != null) {
            for (Object object : this.touchItemKeyList) {
                if (logicModelItems.get(object) != null) continue;
                throw new InvalidModelException("invalid touch-reference in label (key=" + String.valueOf(object) + ")");
            }
        }
        if (this.headerAddOns != null) {
            for (LabelAddOn labelAddOn : this.headerAddOns) {
                labelAddOn.additionalInitializeWizardDisplayModel(logicModelItems);
            }
        }
    }

    private int calcState(List<String> items, WizardDisplayModelItem.ProtectedMap dataModel, String tableKey) {
        int state = 1;
        if (items != null && !items.isEmpty()) {
            int maxPropagateableState = 1;
            int minState = 12;
            for (String currentItem : items) {
                ModelItemDTO miDTO = dataModel.getWithoutTouch(currentItem);
                int newState = miDTO.getState();
                if (ModelItemDTO.isPropagatableState(newState) && ModelItemDTO.isMoreImportantState(newState, maxPropagateableState)) {
                    maxPropagateableState = newState;
                }
                if (ModelItemDTO.isMoreImportantState(newState, minState)) continue;
                minState = newState;
            }
            state = !ModelItemDTO.isPropagatableState(minState) ? minState : maxPropagateableState;
        }
        return state;
    }

    public String toString() {
        return "Form [" + this.name + "] " + this.header;
    }

    public int nextGUIItemUniqueId() {
        return this.nextOutputItemUniqueCounter.getAndDecrement();
    }

    public int nextInputItemUniqueId() {
        return this.nextInputItemUniqueCounter.getAndIncrement();
    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            List elements = element.getChildren();
            ArrayList<WizardDisplayModelItem> childItems = !elements.isEmpty() ? new ArrayList<WizardDisplayModelItem>() : null;
            ArrayList<LabelAddOn> labelAddOns = new ArrayList<LabelAddOn>();
            ArrayList<FormHeaderTemplateAddOn> headerTemplateAddOns = new ArrayList<FormHeaderTemplateAddOn>();
            for (Element subElement : elements) {
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof LabelAddOn) {
                        labelAddOns.add((LabelAddOn)ref);
                        continue;
                    }
                    if (ref instanceof FormHeaderTemplateAddOn) {
                        headerTemplateAddOns.add((FormHeaderTemplateAddOn)ref);
                        continue;
                    }
                    if (ref instanceof WizardDisplayModelItem) {
                        childItems.add((WizardDisplayModelItem)ref);
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + String.valueOf(ref));
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), (Throwable)pnre);
                }
            }
            if (labelAddOns.isEmpty() && element.getAttribute("header-add-on") != null) {
                labelAddOns.add(new LabelAddOn(element.getAttributeValue("header-add-on")));
            }
            if (labelAddOns.isEmpty()) {
                labelAddOns = null;
            }
            if (element.getAttributeValue("viewId") != null) {
                throw new ElementParserException("viewId of Form can't be defined, it's always the 'nav_' + DMK.replaceAll('.', '_').toLowerCase(); " + element.getAttributeValue("name"));
            }
            String headerTemplate = element.getAttributeValue("header-template");
            if (headerTemplate == null || "".equals(headerTemplate)) {
                headerTemplate = null;
                headerTemplateAddOns = null;
            }
            Help help = null;
            if (element.getAttribute("help") != null) {
                help = new Help(element.getAttributeValue("help"));
            }
            boolean extraForm = ExpertDisplayUtil.getBoolean(element.getAttributeValue("extraForm"), false);
            boolean autoSetFocus = ExpertDisplayUtil.getBoolean(element.getAttributeValue("autoSetFocus"), true);
            return new ClassObjectPair(Form.class, (Object)new Form(element.getAttributeValue("name"), element.getAttributeValue("header"), help, labelAddOns, element.getAttributeValue("touch"), element.getAttributeValue("printStateItems"), childItems, headerTemplate, headerTemplateAddOns, extraForm, autoSetFocus));
        }
    }
}

