/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.wizarddisplay.items;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.lib.resource.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.DMK;
import ch.dvbern.tax.common.engine.FileData;
import ch.dvbern.tax.common.engine.LMK;
import ch.dvbern.tax.common.engine.wizarddisplay.SpannableItem;
import ch.dvbern.tax.common.engine.wizarddisplay.WizardDisplayModelItem;
import ch.dvbern.tax.common.engine.wizarddisplay.items.ColDef;
import ch.dvbern.tax.common.engine.wizarddisplay.items.LabelAddOn;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Row;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Section;
import ch.dvbern.tax.common.presentation.common.util.Render;
import ch.dvbern.tax.common.presentation.common.util.RenderBuilder;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.dto.WizardDisplayInfoDTO;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileDetails
extends WizardDisplayModelItem
implements WizardDisplayInfoDTO.ReRenderer,
WizardDisplayInfoDTO.ItemWithStyle,
SpannableItem {
    private static final Logger LOG = LoggerFactory.getLogger(FileDetails.class);
    private final @NonNull LMK valueLmk;
    private final @Nullable String titleKey;
    private final @Nullable String otherParams;
    private final int colspan;
    private final @Nullable String styleClass;
    private final @Nullable List<LabelAddOn> labelAddOns;
    private final @Nullable Render reRender;

    public @NonNull FileDetails(@NonNull LMK valueLmk, @Nullable String titleKey, @Nullable String otherParams, int colspan, @Nullable String styleClass, @Nullable List<LabelAddOn> labelAddOns, @Nullable Render reRender) {
        this.valueLmk = valueLmk;
        this.titleKey = titleKey;
        this.otherParams = otherParams;
        this.colspan = colspan;
        this.styleClass = styleClass;
        this.labelAddOns = labelAddOns;
        this.reRender = reRender;
        LOG.debug("FileDetails: valueLmk={}, colspan={}, styleClass={}", new Object[]{valueLmk, colspan, styleClass});
    }

    public @Nullable List<WizardDisplayModelItem> getChildren() {
        return null;
    }

    @Override
    public int getColspan() {
        return this.colspan;
    }

    @Override
    public @Nullable WizardDisplayInfoDTO.FileDetailsItemDTO getFormInfo(WizardDisplayModelItem.ProtectedMap dataModel, @NonNull String key) {
        DMK dmk = DMK.parse(key).merge(this.valueLmk);
        ModelItemDTO modelItem = dataModel.getModelItem(dmk);
        FileData fileData = (FileData)modelItem.getValue();
        Object fileName = null;
        if (fileData != null && ((String)(fileName = fileData.getFileName())).length() > 42) {
            fileName = ((String)fileName).substring(0, 38) + "..." + ((String)fileName).substring(((String)fileName).length() - 4);
        }
        ArrayList<WizardDisplayInfoDTO.LabelAddOnDTO> labelAddOnDTOs = new ArrayList<WizardDisplayInfoDTO.LabelAddOnDTO>();
        if (this.labelAddOns != null) {
            for (LabelAddOn element : this.labelAddOns) {
                WizardDisplayInfoDTO.LabelAddOnDTO formInfo = element.getFormInfo(dataModel, key);
                if (formInfo == null) continue;
                labelAddOnDTOs.add(formInfo);
            }
        }
        if (labelAddOnDTOs.isEmpty()) {
            labelAddOnDTOs = null;
        }
        Row row = (Row)this.getParent();
        int index = row.getIndex(this);
        int width = 0;
        boolean isWidthUndefined = false;
        int corrColspan = this.colspan;
        for (int i = 0; i < this.colspan; ++i) {
            ColDef coldef = ((Section)row.getParent()).getColdefs().get(index + i);
            WizardDisplayInfoDTO.ColDefItemDTO cdiDTO = coldef.getFormInfo(dataModel, key);
            if (cdiDTO.getState() == 12) {
                --corrColspan;
                continue;
            }
            if (!cdiDTO.isWidthUndefined() && !isWidthUndefined) {
                width += Integer.parseInt(cdiDTO.getWidth());
                continue;
            }
            width = 0;
            isWidthUndefined = true;
        }
        if (corrColspan <= 0) {
            return null;
        }
        return new WizardDisplayInfoDTO.FileDetailsItemDTO(this.getUniqueItemIdentifier(), fileData, modelItem.getState(), (String)fileName, dmk, this.titleKey, this.otherParams, corrColspan, width, this.styleClass, labelAddOnDTOs, this.reRender);
    }

    @Override
    public @Nullable Render getReRender() {
        return this.reRender;
    }

    @Override
    public @Nullable String getStyleClass() {
        return this.styleClass;
    }

    public @NonNull LMK getValueLmk() {
        return this.valueLmk;
    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            List elements = element.getChildren();
            ArrayList<LabelAddOn> labelAddOns = new ArrayList<LabelAddOn>();
            for (Element subElement : elements) {
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof LabelAddOn) {
                        labelAddOns.add((LabelAddOn)ref);
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + String.valueOf(ref));
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), (Throwable)pnre);
                }
            }
            String value = element.getAttributeValue("value");
            if (value == null || value.isEmpty()) {
                throw new ElementParserException("missing value argument for " + String.valueOf(element));
            }
            int colspan = element.getAttribute("colspan") != null ? Integer.parseInt(element.getAttributeValue("colspan")) : 1;
            Render reRender = new Render();
            if (element.getAttribute("reRender") != null) {
                reRender = RenderBuilder.create(element.getAttributeValue("reRender")).build();
            }
            return new ClassObjectPair(FileDetails.class, (Object)new FileDetails(new LMK(element.getAttributeValue("value")), element.getAttributeValue("titleKey"), element.getAttributeValue("otherParams"), colspan, element.getAttributeValue("styleClass"), labelAddOns, reRender));
        }
    }
}

