/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.validators;

import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.ComplexCalcItem;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.Validator;
import ch.dvbern.tax.common.engine.util.FastStack;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;

public class SetDefaultValueValidator
implements Validator {
    private final CalcItem[] calcItems;
    private boolean alwaysTouch = false;
    private boolean showWarning = false;
    private String warningMessageKey = null;
    private static final String DEFAULT_WARNING_MESSAGE = "warning.msg.default.value.changed";

    public SetDefaultValueValidator(CalcItem[] calcItems) {
        this.calcItems = (CalcItem[])calcItems.clone();
    }

    public SetDefaultValueValidator(CalcItem[] calcItems, boolean alwaysTouch) {
        this.calcItems = (CalcItem[])calcItems.clone();
        this.alwaysTouch = alwaysTouch;
    }

    public SetDefaultValueValidator(CalcItem[] calcItems, boolean showWarning, String warningMessageKey) {
        this.calcItems = (CalcItem[])calcItems.clone();
        this.showWarning = showWarning;
        this.warningMessageKey = warningMessageKey;
    }

    @Override
    public void initializeReferences(@NonNull Map<String, LogicModelItem> logicModel, @NonNull LogicModelItem logicModelItem) throws InvalidModelException {
        for (CalcItem ci : this.calcItems) {
            if (ci instanceof Reference) {
                ((Reference)((Object)ci)).registerListenerOnReference(logicModel, logicModelItem, false);
                continue;
            }
            if (!(ci instanceof ComplexCalcItem)) continue;
            ((ComplexCalcItem)ci).initializeReferences(logicModel, logicModelItem);
        }
    }

    @Override
    public @NonNull ModelItemDTO validate(LogicModelItem.ProtectedMap dataModel, @NonNull String dataModelKey, @NonNull ModelItemDTO modelItemDTO) {
        Object calcItemsResult;
        ModelItemDTO result = modelItemDTO;
        FastStack stack = new FastStack();
        for (CalcItem calcItem : this.calcItems) {
            try {
                calcItem.evaluate(dataModel, stack, dataModelKey);
            }
            catch (RuntimeException rte) {
                throw new IllegalArgumentException("Error evaluating CalcItem: " + dataModelKey, rte);
            }
        }
        Object object = calcItemsResult = !stack.isEmpty() ? stack.pop() : null;
        if (result.getValue() == null) {
            result = result.clone(calcItemsResult);
            if (this.alwaysTouch) {
                result.setTouched();
            }
        } else if (this.showWarning && !result.getValue().equals(calcItemsResult)) {
            String messageKey = DEFAULT_WARNING_MESSAGE;
            if (this.warningMessageKey != null) {
                messageKey = this.warningMessageKey;
            }
            result = result.clone(2, messageKey, null, 2);
        }
        return result;
    }
}

