/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.validators;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Validator;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;

public class NotNegative
implements Validator {
    private boolean autoCorrect = true;
    private final boolean warning;
    private final String messageKey;
    public static final String DEFAULT_ERROR_KEY = "error.value.notnegative.default";
    public static final String DEFAULT_WARNING_KEY = "warning.value.notnegative.default";
    public static final String DEFAULT_INFO_KEY = "info.value.notnegative.default";
    private final boolean noMessage;

    public NotNegative(boolean autoCorrect, boolean warning, String messageKey, boolean noMessage) {
        this.autoCorrect = autoCorrect;
        this.warning = warning;
        this.messageKey = messageKey;
        this.noMessage = noMessage;
    }

    public NotNegative(boolean autoCorrect, boolean noMessage) {
        this.autoCorrect = autoCorrect;
        this.warning = false;
        this.messageKey = null;
        this.noMessage = noMessage;
    }

    @Override
    public void initializeReferences(@NonNull Map<String, LogicModelItem> logicModel, @NonNull LogicModelItem logicModelItem) throws InvalidModelException {
    }

    @Override
    public @NonNull ModelItemDTO validate(LogicModelItem.ProtectedMap dataModel, @NonNull String dataModelKey, @NonNull ModelItemDTO modelItemDTO) {
        ModelItemDTO result = modelItemDTO;
        if (result.getValue() instanceof Number && ((Number)result.getValue()).doubleValue() < 0.0) {
            if (this.noMessage) {
                result = result.clone(0L);
            } else if (this.autoCorrect) {
                String msg = this.messageKey == null ? DEFAULT_INFO_KEY : this.messageKey;
                result = result.clone(0L, 1, msg, null, 2);
            } else if (this.warning) {
                String msg = this.messageKey == null ? DEFAULT_WARNING_KEY : this.messageKey;
                result = result.clone(2, msg, null, 2);
            } else {
                String msg = this.messageKey == null ? DEFAULT_ERROR_KEY : this.messageKey;
                result = result.clone(4, msg, null, 4);
            }
        }
        return result;
    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            boolean tmpCorrect = element.getAttribute("autocorrect") == null || !element.getAttributeValue("autocorrect").equalsIgnoreCase("false");
            boolean noMessage = element.getAttribute("no-message") != null && element.getAttributeValue("no-message").equalsIgnoreCase("true");
            boolean tmpWarning = Boolean.valueOf(element.getAttributeValue("warning"));
            String tmpMessageKey = element.getAttributeValue("message");
            NotNegative result = new NotNegative(tmpCorrect, tmpWarning, tmpMessageKey, noMessage);
            return new ClassObjectPair(NotNegative.class, (Object)result);
        }
    }
}

