/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.validators;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Validator;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;

public class MatchesRegex
implements Validator {
    private final String regex;
    private final String message;

    public MatchesRegex(String regex, String message) {
        this.regex = regex;
        this.message = message;
    }

    @Override
    public void initializeReferences(@NonNull Map<String, LogicModelItem> logicModel, @NonNull LogicModelItem logicModelItem) throws InvalidModelException {
    }

    @Override
    public @NonNull ModelItemDTO validate(LogicModelItem.ProtectedMap dataModel, @NonNull String dataModelKey, @NonNull ModelItemDTO modelItemDTO) {
        String strValue;
        Object value = modelItemDTO.getValue();
        if (value instanceof String && !(strValue = (String)value).matches(this.regex)) {
            modelItemDTO = modelItemDTO.clone(4, this.message, null, 4);
        }
        return modelItemDTO;
    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            String regex = element.getAttributeValue("regex");
            String message = element.getAttributeValue("message");
            MatchesRegex instance = new MatchesRegex(regex, message);
            return new ClassObjectPair(MatchesRegex.class, (Object)instance);
        }
    }
}

