/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.validators;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.lib.resource.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.ComplexCalcItem;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.Validator;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.engine.util.FastStack;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Mandatory
implements Validator {
    private final @NonNull List<CalcItem> calcItems;
    private final boolean warning;
    private final @Nullable String messageKey;
    private final @Nullable Reference refLabelAddOn;
    private static final String DEFAULT_WARNING_KEY = "warning.missing.data.default";
    private static final String DEFAULT_ERROR_KEY = "error.missing.data.default";

    public Mandatory(boolean warning, @Nullable String messageKey, @Nullable Reference refLabelAddOn) {
        this.warning = warning;
        this.messageKey = messageKey;
        this.calcItems = new ArrayList<CalcItem>();
        this.refLabelAddOn = refLabelAddOn;
    }

    public Mandatory(@NonNull List<CalcItem> calcItems, boolean warning, @Nullable String messageKey, @Nullable Reference refLabelAddOn) {
        this.calcItems = calcItems;
        this.warning = warning;
        this.messageKey = messageKey;
        this.refLabelAddOn = refLabelAddOn;
    }

    @Override
    public void initializeReferences(@NonNull Map<String, LogicModelItem> logicModel, @NonNull LogicModelItem logicModelItem) throws InvalidModelException {
        for (CalcItem ci : this.calcItems) {
            if (ci instanceof Reference) {
                ((Reference)((Object)ci)).registerListenerOnReference(logicModel, logicModelItem, false);
                continue;
            }
            if (!(ci instanceof ComplexCalcItem)) continue;
            ((ComplexCalcItem)ci).initializeReferences(logicModel, logicModelItem);
        }
        if (this.refLabelAddOn != null) {
            this.refLabelAddOn.registerListenerOnReference(logicModel, logicModelItem, false);
        }
    }

    @Override
    public @NonNull ModelItemDTO validate(@NonNull LogicModelItem.ProtectedMap dataModel, @NonNull String dataModelKey, @NonNull ModelItemDTO modelItemDTO) {
        Object value;
        FastStack stack = new FastStack();
        for (CalcItem calcItem : this.calcItems) {
            try {
                calcItem.evaluate(dataModel, stack, dataModelKey);
            }
            catch (RuntimeException rte) {
                throw new IllegalArgumentException("Error evaluating CalcItem: " + dataModelKey, rte);
            }
        }
        Object object = value = stack.isEmpty() ? null : stack.pop();
        if ((value instanceof Boolean && ((Boolean)value).booleanValue() || value == null) && modelItemDTO.getValue() == null) {
            if (modelItemDTO.isTouched()) {
                String msg;
                ModelItemDTO mid;
                Object labelAddOn = null;
                if (this.refLabelAddOn != null && (mid = dataModel.get(EngineUtil.mergeModelKey(this.refLabelAddOn.getName(), dataModelKey))) != null) {
                    labelAddOn = mid.getValue();
                }
                if (this.warning) {
                    msg = this.messageKey == null ? DEFAULT_WARNING_KEY : this.messageKey;
                    modelItemDTO = modelItemDTO.clone(2, msg, labelAddOn, 2);
                } else {
                    msg = this.messageKey == null ? DEFAULT_ERROR_KEY : this.messageKey;
                    modelItemDTO = modelItemDTO.clone(4, msg, labelAddOn, 4);
                }
            } else {
                modelItemDTO = modelItemDTO.clone(3);
            }
        }
        return modelItemDTO;
    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            ArrayList<CalcItem> calcItems = new ArrayList<CalcItem>();
            List elements = element.getChildren();
            for (Element subElement : elements) {
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof CalcItem) {
                        calcItems.add((CalcItem)ref);
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + String.valueOf(ref));
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), (Throwable)pnre);
                }
            }
            Reference refLabelAddOn = null;
            if (element.getAttribute("message-add-on-rel-ref") != null) {
                refLabelAddOn = new Reference(element.getAttributeValue("message-add-on-rel-ref"), true);
            }
            if (element.getAttribute("message-add-on-abs-ref") != null) {
                refLabelAddOn = new Reference(element.getAttributeValue("message-add-on-abs-ref"), false);
            }
            String tmpMessageKey = element.getAttributeValue("message");
            boolean tmpWarning = false;
            if (element.getAttribute("warning") != null) {
                tmpWarning = Boolean.parseBoolean(element.getAttributeValue("warning"));
            }
            Mandatory result = !calcItems.isEmpty() ? new Mandatory(calcItems, tmpWarning, tmpMessageKey, refLabelAddOn) : new Mandatory(tmpWarning, tmpMessageKey, refLabelAddOn);
            return new ClassObjectPair(Mandatory.class, (Object)result);
        }
    }
}

