/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.validators;

import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.Validator;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcludedRangeValidator
implements Validator {
    private static final Logger LOG = LoggerFactory.getLogger(ExcludedRangeValidator.class);
    private final Reference refVergleichswert;
    private final Double toleranceMax;
    private final Double toleranceMin;
    private final boolean warning;
    private final String messageKey;
    private static final String DEFAULT_ERROR_KEY = "error.value.abweichung.default";
    private static final String DEFAULT_WARNING_KEY = "warning.value.abweichung.default";

    public ExcludedRangeValidator(Reference refVergleichswert, double toleranceMin, boolean warning, String messageKey) {
        this.refVergleichswert = refVergleichswert;
        this.toleranceMax = null;
        this.toleranceMin = Double.valueOf("" + toleranceMin);
        this.warning = warning;
        this.messageKey = messageKey;
    }

    public ExcludedRangeValidator(Reference refVergleichswert, double toleranceMin, double toleranceMax, boolean warning, String messageKey) {
        this.refVergleichswert = refVergleichswert;
        this.toleranceMax = Double.valueOf("" + toleranceMax);
        this.toleranceMin = Double.valueOf("" + toleranceMin);
        this.warning = warning;
        this.messageKey = messageKey;
    }

    @Override
    public void initializeReferences(@NonNull Map<String, LogicModelItem> logicModel, @NonNull LogicModelItem logicModelItem) throws InvalidModelException {
        this.refVergleichswert.registerListenerOnReference(logicModel, logicModelItem, false);
    }

    @Override
    public @NonNull ModelItemDTO validate(LogicModelItem.ProtectedMap dataModel, @NonNull String dataModelKey, @NonNull ModelItemDTO modelItemDTO) {
        ModelItemDTO result = modelItemDTO;
        if (result != null && result.getValue() instanceof Number) {
            Number resultAsNumber = (Number)result.getValue();
            String vergleichswertLogicName = this.refVergleichswert.getReference().getName();
            String vergleichswertDMK = EngineUtil.mergeModelKey(vergleichswertLogicName, dataModelKey);
            if (dataModel.get(vergleichswertDMK) == null) {
                return result;
            }
            ModelItemDTO vergleichswert = dataModel.get(vergleichswertDMK);
            if (vergleichswert != null && vergleichswert.getValue() instanceof Number) {
                double maxUnterschritten;
                double maxUeberschritten;
                double vergleichswertAsNumber = ((Number)dataModel.get(vergleichswertDMK).getValue()).doubleValue();
                double value = resultAsNumber.doubleValue();
                double minUeberschritten = (1.0 + this.toleranceMin) * vergleichswertAsNumber;
                double minUnterschritten = (1.0 - this.toleranceMin) * vergleichswertAsNumber;
                if (this.toleranceMax == null) {
                    maxUeberschritten = Double.MAX_VALUE;
                    maxUnterschritten = -1.7976931348623157E308;
                } else {
                    maxUeberschritten = (1.0 + this.toleranceMax) * vergleichswertAsNumber;
                    maxUnterschritten = (1.0 - this.toleranceMax) * vergleichswertAsNumber;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("value: " + value);
                    LOG.debug("vergleichswert: " + vergleichswertAsNumber);
                    LOG.debug("toleranz von " + this.toleranceMin + " bis " + this.toleranceMax);
                    LOG.debug("... also darf wert nicht zwischen " + maxUnterschritten + " und " + minUnterschritten + " oder zwischen " + minUeberschritten + " und " + maxUeberschritten + " liegen");
                }
                boolean validate = true;
                if (minUeberschritten < value && value <= maxUeberschritten) {
                    validate = false;
                }
                if (maxUnterschritten <= value && value < minUnterschritten) {
                    validate = false;
                }
                if (!validate) {
                    if (this.warning) {
                        String msg = this.messageKey == null ? DEFAULT_WARNING_KEY : this.messageKey;
                        result = result.clone(2, msg, resultAsNumber, 2);
                    } else {
                        String msg = this.messageKey == null ? DEFAULT_ERROR_KEY : this.messageKey;
                        result = result.clone(4, msg, resultAsNumber, 4);
                    }
                }
            }
        }
        return result;
    }
}

