/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.validators;

import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.ComplexCalcItem;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.Validator;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.engine.util.FastStack;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateDefaultTableEntry
implements Validator {
    private static final Logger LOG = LoggerFactory.getLogger(CreateDefaultTableEntry.class);
    private final CalcItem[] calcItems;
    private final Reference tableRef;

    public CreateDefaultTableEntry(CalcItem[] calcItems, Reference table) {
        this.calcItems = (CalcItem[])calcItems.clone();
        this.tableRef = table;
    }

    @Override
    public void initializeReferences(@NonNull Map<String, LogicModelItem> logicModel, @NonNull LogicModelItem logicModelItem) throws InvalidModelException {
        for (CalcItem ci : this.calcItems) {
            if (ci instanceof Reference) {
                ((Reference)((Object)ci)).registerListenerOnReference(logicModel, logicModelItem, false);
                continue;
            }
            if (!(ci instanceof ComplexCalcItem)) continue;
            ((ComplexCalcItem)ci).initializeReferences(logicModel, logicModelItem);
        }
        this.tableRef.initializeReference(logicModel, logicModelItem, true);
    }

    @Override
    public @NonNull ModelItemDTO validate(LogicModelItem.ProtectedMap dataModel, @NonNull String dataModelKey, @NonNull ModelItemDTO modelItemDTO) {
        Object value;
        FastStack stack = new FastStack();
        for (CalcItem ci : this.calcItems) {
            try {
                ci.evaluate(dataModel, stack, dataModelKey);
            }
            catch (RuntimeException rte) {
                throw new IllegalArgumentException("Error evaluating CalcItem: " + dataModelKey, rte);
            }
        }
        Object object = value = !stack.isEmpty() ? stack.pop() : null;
        if (value == null || !((Boolean)value).booleanValue()) {
            LOG.debug("no default table entry created because the condition is false");
            return modelItemDTO;
        }
        boolean tableIsEmpty = false;
        String tableDmk = EngineUtil.mergeModelKey(this.tableRef.getName(), dataModelKey);
        ModelItemDTO miDto = dataModel.get(tableDmk);
        if (miDto == null) {
            tableIsEmpty = true;
        } else {
            Set indizes = (Set)miDto.getValue();
            if (indizes.isEmpty()) {
                tableIsEmpty = true;
            }
        }
        if (!tableIsEmpty) {
            LOG.debug("no default table entry created because the table is not empty");
            return modelItemDTO;
        }
        LogicModelItem.TableItem table = (LogicModelItem.TableItem)((Object)this.tableRef.getReference());
        int index = EngineUtil.getNextTableItemIndex(dataModel, table, tableDmk);
        List<LogicModelItem> childern = ((LogicModelItem)((Object)table)).getChildren();
        if (childern.isEmpty()) {
            LOG.debug("no default table entry created because the does not contain any childern");
            return modelItemDTO;
        }
        LogicModelItem firstChild = childern.get(0);
        String itemDmk = EngineUtil.mergeModelKey(firstChild.getName(), tableDmk + "." + index);
        if (LOG.isDebugEnabled()) {
            LOG.debug("creating default table entry with dmk=" + itemDmk);
        }
        ModelItemDTO dummy = new ModelItemDTO();
        firstChild.setValue(dataModel, itemDmk, dummy, "true");
        LOG.debug("default table entry created");
        return modelItemDTO;
    }
}

