/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.util;

import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.math.BigDecimal;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class MathUtil {
    private MathUtil() {
    }

    public static @NonNull BigDecimal toBigDecimal(Number numberValue) {
        return new BigDecimal(String.valueOf(numberValue));
    }

    public static @NonNull BigDecimal toBigDecimal(@Nullable ModelItemDTO numericMiDTO) {
        if (numericMiDTO == null || !(numericMiDTO.getValue() instanceof Number)) {
            return BigDecimal.ZERO;
        }
        BigDecimal bdValue = MathUtil.toBigDecimal((Number)numericMiDTO.getValue());
        return bdValue;
    }

    public static @Nullable Number toAnyNumber(@Nullable BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            return null;
        }
        BigDecimal resultStripped = bigDecimal.stripTrailingZeros();
        Number resultNumber = resultStripped.scale() <= 0 ? (Number)resultStripped.longValue() : (Number)resultStripped.doubleValue();
        return resultNumber;
    }
}

