/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.util;

import ch.dvbern.tax.common.engine.DataResourceBase;
import ch.dvbern.tax.common.engine.util.ResourceProvider;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ClassPathResourceProvider
implements ResourceProvider {
    private final String prefix;

    public ClassPathResourceProvider() {
        this("");
    }

    public ClassPathResourceProvider(@NonNull String prefix) {
        this(prefix, null);
    }

    public ClassPathResourceProvider(@NonNull String prefix, @Nullable Class<?> relativeTo) {
        if (prefix == null) {
            throw new NullPointerException("Prefix cannot be null.");
        }
        if (relativeTo != null) {
            Package pkg = relativeTo.getPackage();
            if (pkg == null) {
                throw new IllegalArgumentException("Cannot retrieve relative package.");
            }
            prefix = relativeTo.getPackage().getName().replace('.', '/') + "/" + (String)prefix;
        }
        this.prefix = prefix;
    }

    @Override
    public @NonNull Reader getReader(@NonNull String path) {
        if (path == null) {
            throw new NullPointerException("Resource path cannot be null.");
        }
        path = this.prefix + (String)path;
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream((String)path);
        if (is == null) {
            throw new IllegalArgumentException("No resource available at path: " + (String)path);
        }
        return new InputStreamReader(is, DataResourceBase.RESOURCES_CHARSET);
    }
}

