/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.modelloader;

import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ModelSource {
    public static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private final URL url;
    private final Charset charset;

    public static @NonNull ModelSource of(@NonNull URL entry) {
        return new ModelSource(entry, DEFAULT_CHARSET);
    }

    private ModelSource(@NonNull URL url, @NonNull Charset charset) {
        this.url = Objects.requireNonNull(url);
        this.charset = Objects.requireNonNull(charset);
    }

    public String toString() {
        return String.format("%s[%s]", this.getClass().getSimpleName(), this.url);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModelSource)) {
            return false;
        }
        ModelSource that = (ModelSource)o;
        try {
            return this.getUrl().toURI().equals(that.getUrl().toURI());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("unexpected: " + String.valueOf(this) + "/" + String.valueOf(that), e);
        }
    }

    public int hashCode() {
        return Objects.hash(this.getUrl());
    }

    public @NonNull URL getUrl() {
        return this.url;
    }

    public @NonNull Charset getCharset() {
        return this.charset;
    }
}

