/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.modelloader;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.IOUtils;
import org.checkerframework.checker.nullness.qual.NonNull;

public class MergedModel {
    private final byte @NonNull [] xmlBytes;
    private final @NonNull Charset charset;

    private MergedModel(byte @NonNull [] xmlBytes, @NonNull Charset charset) {
        this.xmlBytes = xmlBytes;
        this.charset = charset;
    }

    public static @NonNull MergedModel from(byte @NonNull [] xmlBytes, @NonNull Charset charset) {
        return new MergedModel(xmlBytes, charset);
    }

    public static @NonNull MergedModel fromFile(@NonNull Path modelPath) throws IOException {
        try (InputStream fileStream = Files.newInputStream(modelPath, new OpenOption[0]);){
            MergedModel mergedModel;
            try (GZIPInputStream is = new GZIPInputStream(new BufferedInputStream(fileStream));){
                byte[] bytes = IOUtils.toByteArray((InputStream)is);
                Charset encoding = StandardCharsets.ISO_8859_1;
                mergedModel = new MergedModel(bytes, encoding);
            }
            return mergedModel;
        }
    }

    public @NonNull String asString() {
        return new String(this.getXmlBytes(), this.charset);
    }

    public @NonNull InputStream openStream() {
        return new ByteArrayInputStream(this.xmlBytes);
    }

    public byte @NonNull [] getXmlBytes() {
        return this.xmlBytes;
    }

    public @NonNull Charset getCharset() {
        return this.charset;
    }
}

