/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.modelitems.addons;

import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.Validator;
import ch.dvbern.tax.common.engine.modelitems.Value;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ValueWithoutInputvalidation
extends Value {
    private Reference[] modificationValidationEventSources = null;
    private boolean hasInitialGreenState = false;

    public ValueWithoutInputvalidation(String name, String persistenceKeyTemplate, String importPrevious, Object[] validators) {
        super(name, persistenceKeyTemplate, null, false, importPrevious, false, false, false);
        for (Object o : validators) {
            if (!(o instanceof Validator)) continue;
            this.addValidator((Validator)o);
        }
    }

    public ValueWithoutInputvalidation(String name, String persistenceKeyTemplate, boolean importPrevious, Object[] validators) {
        this(name, persistenceKeyTemplate, Boolean.toString(importPrevious), validators);
    }

    public ValueWithoutInputvalidation(String name, String persistenceKeyTemplate, String importPrevious, Object[] validators, Reference[] modificationValidationEventSources) {
        this(name, persistenceKeyTemplate, importPrevious, validators);
        this.modificationValidationEventSources = (Reference[])modificationValidationEventSources.clone();
    }

    public ValueWithoutInputvalidation(String name, String persistenceKeyTemplate, String importPrevious, Object[] validators, Reference[] modificationValidationEventSources, boolean hasInitialGreenState) {
        this(name, persistenceKeyTemplate, importPrevious, validators);
        this.modificationValidationEventSources = (Reference[])modificationValidationEventSources.clone();
        this.hasInitialGreenState = hasInitialGreenState;
    }

    @Override
    protected void additionalInitializeReferences(Map<String, LogicModelItem> logicModel) throws InvalidModelException {
        if (this.modificationValidationEventSources != null) {
            for (Reference modificationValidationEventSource : this.modificationValidationEventSources) {
                modificationValidationEventSource.initializeReference(logicModel, this, false);
            }
        }
        super.additionalInitializeReferences(logicModel);
    }

    @Override
    public void setValue(@NonNull LogicModelItem.ProtectedMap dataModel, @NonNull String dataModelKey, @NonNull ModelItemDTO modelItemDTO, @Nullable String changedEventsOnlyOutsideOfThisTable) {
        this.setValueWithOptionalValidation(dataModel, dataModelKey, modelItemDTO, changedEventsOnlyOutsideOfThisTable, false, false);
    }

    @Override
    protected boolean hasAnInitialGreenState() {
        return this.hasInitialGreenState;
    }

    @Override
    public void dataChanged(@NonNull LogicModelItem.ProtectedMap dataModel, @NonNull String dataModelKey, @Nullable ModelItemDTO oldValue, @Nullable ModelItemDTO newValue, @Nullable String changedEventsOnlyOutsideOfThisTable) {
        boolean modificationEventSource = false;
        if (this.modificationValidationEventSources != null) {
            String currentModificationEventSource = EngineUtil.removeTableIndices(dataModelKey);
            for (int i = 0; i < this.modificationValidationEventSources.length && !modificationEventSource; ++i) {
                String itemName = this.modificationValidationEventSources[i].getName();
                if (!currentModificationEventSource.equals(itemName)) continue;
                modificationEventSource = true;
            }
        }
        super.dataChangedWithConditionalActiveValidation(dataModel, dataModelKey, changedEventsOnlyOutsideOfThisTable, modificationEventSource);
    }
}

