/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.modelitems.addons;

import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.persistence.SimpleValuePersistenceHint;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TableEntryCounter
extends LogicModelItem
implements LogicModelItem.TableItem.TableEventListener {
    private final Reference table;
    private final Reference trigger;

    public TableEntryCounter(String name, Reference table) {
        this(name, table, null);
    }

    public TableEntryCounter(String name, Reference table, Reference trigger) {
        super(name, null, null, true, "false", true, false, new SimpleValuePersistenceHint());
        this.table = table;
        this.trigger = trigger;
    }

    @Override
    protected void additionalInitializeReferences(Map<String, LogicModelItem> logicModel) throws InvalidModelException {
        super.additionalInitializeReferences(logicModel);
        this.table.initializeReference(logicModel, this, false);
        LogicModelItem tableLMI = this.table.getReference();
        if (!(tableLMI instanceof LogicModelItem.TableItem)) {
            throw new InvalidModelException(this.table.getName() + " must be a table item.");
        }
        if (this.trigger != null) {
            this.trigger.initializeReference(logicModel, this, false);
            this.trigger.registerListenerOnReference(logicModel, this, false);
        }
        ((LogicModelItem.TableItem)((Object)tableLMI)).addTableEventListener(this);
    }

    @Override
    public void onTableEntryAdd(LogicModelItem source, LogicModelItem.ProtectedMap dataModel, String tableDMK, String index) {
        this.updateCounter(dataModel, tableDMK);
    }

    @Override
    public void onTableEntryRemove(LogicModelItem source, LogicModelItem.ProtectedMap dataModel, String tableDMK, String index) {
        this.updateCounter(dataModel, tableDMK);
    }

    @Override
    public void onTableValueRemove(LogicModelItem source, LogicModelItem.ProtectedMap dataModel, ModelItemDTO removedDTO, String tableDMK) {
    }

    private void updateCounter(LogicModelItem.ProtectedMap dataModel, String dmk) {
        String tableDMK = EngineUtil.mergeModelKey(this.table.getName(), dmk);
        String counterDMK = EngineUtil.mergeModelKey(this.getName(), tableDMK);
        ModelItemDTO tableDTO = dataModel.get(tableDMK);
        Object indexes = tableDTO != null ? tableDTO.getValue() : null;
        long value = 0L;
        if (indexes != null) {
            value = ((Set)indexes).size();
        }
        ModelItemDTO counterDTO = new ModelItemDTO(value, 1);
        counterDTO.setTouched();
        this.setValue(dataModel, counterDMK, counterDTO, null);
    }

    @Override
    public void dataChanged(@NonNull LogicModelItem.ProtectedMap dataModel, @NonNull String dataModelKey, @Nullable ModelItemDTO oldValue, @Nullable ModelItemDTO newValue, @Nullable String changedEventsOnlyOutsideOfThisTable) {
        this.updateCounter(dataModel, dataModelKey);
    }
}

