/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.modelitems.addons;

import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.persistence.SimpleValuePersistenceHint;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SimpleItemCopyIfNotNull
extends LogicModelItem {
    private final Reference sourceItem;
    private final Reference targetItem;

    public SimpleItemCopyIfNotNull(String name, Reference sourceItem, Reference targetItem) {
        super(name, null, null, true, "false", true, false, new SimpleValuePersistenceHint());
        this.sourceItem = sourceItem;
        this.targetItem = targetItem;
    }

    @Override
    protected void additionalInitializeReferences(Map<String, LogicModelItem> logicModel) throws InvalidModelException {
        super.additionalInitializeReferences(logicModel);
        this.sourceItem.registerListenerOnReference(logicModel, this, false);
        this.targetItem.initializeReference(logicModel, this, false);
    }

    @Override
    public void dataChanged(@NonNull LogicModelItem.ProtectedMap dataModel, @NonNull String dataModelKey, @Nullable ModelItemDTO oldValue, @Nullable ModelItemDTO newValue, @Nullable String changedEventsOnlyOutsideOfThisTable) {
        if (newValue == null) {
            return;
        }
        if (newValue.getValue() == null) {
            return;
        }
        if (changedEventsOnlyOutsideOfThisTable != null && dataModelKey.startsWith(changedEventsOnlyOutsideOfThisTable)) {
            return;
        }
        String dmk = EngineUtil.mergeModelKey(this.targetItem.getName(), dataModelKey);
        dataModel.getAsyncUpdates().put(dmk, newValue);
    }
}

