/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.modelitems.addons;

import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.persistence.SimpleValuePersistenceHint;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ItemEventOnMultipleTableEntriesHelper
extends LogicModelItem {
    private final Reference tableWithTheItems;
    private final Collection<Reference> theItems;

    public ItemEventOnMultipleTableEntriesHelper(String name, Reference tableWithTheItems, Reference[] theItems) {
        super(name, null, null, true, "false", true, false, new SimpleValuePersistenceHint());
        this.tableWithTheItems = tableWithTheItems;
        this.theItems = Arrays.asList(theItems);
    }

    @Override
    protected void additionalInitializeReferences(Map<String, LogicModelItem> logicModel) throws InvalidModelException {
        super.additionalInitializeReferences(logicModel);
        for (Reference reference : this.theItems) {
            reference.registerListenerOnReference(logicModel, this, false);
        }
    }

    @Override
    public void dataChanged(@NonNull LogicModelItem.ProtectedMap dataModel, @NonNull String dataModelKey, @Nullable ModelItemDTO oldValue, @Nullable ModelItemDTO newValue, @Nullable String changedEventsOnlyOutsideOfThisTable) {
        if (changedEventsOnlyOutsideOfThisTable != null && dataModelKey.startsWith(changedEventsOnlyOutsideOfThisTable)) {
            return;
        }
        String tableDMK = EngineUtil.mergeModelKey(this.tableWithTheItems.getName(), dataModelKey);
        tableDMK = EngineUtil.removeLastKeyPart(tableDMK);
        Set tableIndices = (Set)dataModel.get(tableDMK).getValue();
        for (Object tableIndice : tableIndices) {
            String index = tableIndice.toString();
            String otherItemDMK = this.replaceTableEntryIndex(dataModelKey, tableDMK, index);
            for (Reference r : this.theItems) {
                r.getReference().dataChanged(dataModel, otherItemDMK, oldValue, newValue, changedEventsOnlyOutsideOfThisTable);
            }
        }
    }

    private String replaceTableEntryIndex(String dataModelKey, String tableDMK, String index) {
        String subDMK = dataModelKey.substring(tableDMK.length() + 1);
        subDMK = subDMK.substring(subDMK.indexOf(46));
        return tableDMK + "." + index + subDMK;
    }
}

