/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.modelitems;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.lib.resource.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.Engine;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Validator;
import ch.dvbern.tax.common.engine.persistence.FilePersistenceHint;
import ch.dvbern.tax.common.engine.persistence.FilePersistenceParam;
import ch.dvbern.tax.common.engine.persistence.PersistenceHint;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class File
extends LogicModelItem {
    public File(@NonNull String name, @NonNull String fileId, @NonNull String persistenceKeyTemplate, boolean readonly, boolean readonlyIfTransparent) {
        super(name, null, persistenceKeyTemplate, readonly, "false", readonlyIfTransparent, false, File.buildHint(fileId));
    }

    @Override
    protected @Nullable ModelItemDTO getDefaultValue(LogicModelItem.ProtectedMap dataModel, String dataModelKey) {
        ModelItemDTO fileDTO = new ModelItemDTO(null, 1);
        fileDTO.setTouched();
        return fileDTO;
    }

    private static @NonNull PersistenceHint<FilePersistenceParam> buildHint(@NonNull String fileId) {
        return new FilePersistenceHint(new FilePersistenceParam(Objects.requireNonNull(fileId)));
    }

    @Override
    public boolean hasAnInitialGreenState() {
        return true;
    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            ArrayList<Validator> validators = new ArrayList<Validator>();
            List elements = element.getChildren();
            for (Element subElement : elements) {
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof Validator) {
                        validators.add((Validator)ref);
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + String.valueOf(ref));
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), (Throwable)pnre);
                }
            }
            Engine.setMandatory(element, validators);
            File result = new File(Objects.requireNonNull(element.getAttributeValue("name"), "Attribute 'name' required"), Objects.requireNonNull(element.getAttributeValue("fileId"), "Attribute 'fileId' required"), Objects.requireNonNull(element.getAttributeValue("pKey"), "Attribute 'pKey' required"), Boolean.valueOf(element.getAttributeValue("readonly")), Boolean.valueOf(element.getAttributeValue("readonly-if-transparent")));
            for (Validator v : validators) {
                result.addValidator(v);
            }
            return new ClassObjectPair(File.class, (Object)result);
        }
    }
}

