/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.modelitems;

import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.persistence.SimpleValuePersistenceHint;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CalcBooleanFromState
extends LogicModelItem {
    private final Reference[] references;

    public CalcBooleanFromState(String name, Reference[] references) {
        super(name, null, null, true, "false", false, false, new SimpleValuePersistenceHint());
        this.references = (Reference[])references.clone();
    }

    @Override
    public void additionalInitializeReferences(Map<String, LogicModelItem> logicModel) throws InvalidModelException {
        for (Reference reference : this.references) {
            reference.registerListenerOnReference(logicModel, this, false);
        }
    }

    @Override
    public void setValue(@NonNull LogicModelItem.ProtectedMap dataModel, @NonNull String dataModelKey, @NonNull ModelItemDTO modelItemDTO, @Nullable String changedEventsOnlyOutsideOfThisTable) {
    }

    @Override
    public void dataChanged(@NonNull LogicModelItem.ProtectedMap dataModel, @NonNull String dataModelKey, @Nullable ModelItemDTO oldValue, @Nullable ModelItemDTO newValue, @Nullable String changedEventsOnlyOutsideOfThisTable) {
    }

    @Override
    public void stateChanged(@NonNull LogicModelItem.ProtectedMap dataModel, @NonNull String dataModelKey, @Nullable ModelItemDTO oldValue, @Nullable ModelItemDTO newValue, @Nullable String changedEventsOnlyOutsideOfThisTable) {
        String dmk = EngineUtil.mergeModelKey(this.getName(), dataModelKey);
        if (changedEventsOnlyOutsideOfThisTable != null && dmk.startsWith(changedEventsOnlyOutsideOfThisTable)) {
            return;
        }
        Boolean result = Boolean.TRUE;
        for (Reference reference : this.references) {
            ModelItemDTO miDTO = dataModel.get(reference.getName());
            if (miDTO != null && miDTO.getState() != 3 && miDTO.getState() != 4) continue;
            result = Boolean.FALSE;
        }
        super.setValue(dataModel, dmk, new ModelItemDTO(result), changedEventsOnlyOutsideOfThisTable);
    }
}

