/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.expertdisplay;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.lib.resource.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayModel;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayUtil;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertFormDisplayModelItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertFormItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertLabelAddOn;
import ch.dvbern.tax.common.transfer.dto.ColorDTO;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.FontDTO;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ExpertLabelItem
extends ExpertFormDisplayModelItem {
    private final String key;
    private final int x;
    private final int y;
    private final int width;
    private final int height;
    private final int alignment;
    private final FontDTO font;
    private final ColorDTO bgColor;
    private final List<ExpertLabelAddOn> labelAddOns;
    private final boolean printIfAddOnEmpty;
    private final String stateItemName;
    private LogicModelItem stateItem;

    public ExpertLabelItem(String key, int x, int y, int width, int height, int alignment, FontDTO font, ColorDTO bgColor, List<ExpertLabelAddOn> labelAddOns, int printMode, boolean inputItem, Set<String> languages, boolean printIfAddOnEmpty, String stateItemName) {
        super(languages, printMode, inputItem);
        this.key = key;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.alignment = alignment;
        this.font = font;
        this.bgColor = bgColor;
        this.labelAddOns = labelAddOns;
        this.printIfAddOnEmpty = printIfAddOnEmpty;
        this.stateItemName = stateItemName;
    }

    public List<ExpertLabelAddOn> getChildren() {
        return this.labelAddOns;
    }

    @Override
    protected void additionalInitialization(Map<String, LogicModelItem> logicModelItems, Map<String, ExpertFormItem> navigationItems) throws InvalidModelException {
        super.additionalInitialization(logicModelItems, navigationItems);
        if (this.stateItemName != null) {
            this.stateItem = logicModelItems.get(this.stateItemName);
            if (this.stateItem == null) {
                throw new InvalidModelException("invalid state-reference in e-label: " + String.valueOf(this.stateItem));
            }
        }
    }

    @Override
    public ExpertDisplayInfoDTO.ItemDTO getItemDTO(ExpertDisplayModel.RequestContext requestContext) {
        int outputMode = this.getPrintMode();
        ArrayList<ExpertDisplayInfoDTO.LabelDTO.LabelAddOnDTO> labelAddOnDTOs = null;
        if (this.stateItem != null) {
            String dmk = ExpertDisplayUtil.getModelItemKey(this.stateItem, requestContext.getFormAccessKey());
            ModelItemDTO stateDTO = requestContext.getDataModel().get(dmk);
            if (stateDTO != null && stateDTO.getState() == 12) {
                return null;
            }
        }
        if (this.labelAddOns != null && !this.labelAddOns.isEmpty()) {
            labelAddOnDTOs = new ArrayList<ExpertDisplayInfoDTO.LabelDTO.LabelAddOnDTO>();
            for (ExpertLabelAddOn expertLabelAddOn : this.labelAddOns) {
                ExpertDisplayInfoDTO.LabelDTO.LabelAddOnDTO labelAddOnDTO = expertLabelAddOn.getLabelAddOnDTO(requestContext);
                labelAddOnDTOs.add(labelAddOnDTO);
                if (this.printIfAddOnEmpty || labelAddOnDTO.getValue() != null && !labelAddOnDTO.getValue().toString().isEmpty()) continue;
                outputMode = 0;
            }
        }
        ExpertDisplayInfoDTO.LabelDTO labelDto = new ExpertDisplayInfoDTO.LabelDTO(this.x, this.y, this.width, this.height, this.font != null ? this.font : requestContext.getDefaultFont(), this.bgColor, this.alignment, this.key, labelAddOnDTOs, outputMode, this.getUniqueItemIdentifier());
        if (this.getOriginalPosition() != null && this.getOriginalSize() != null) {
            labelDto.setOriginalSettings(this.getOriginalPosition(), this.getOriginalSize());
        }
        return labelDto;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("key", (Object)this.key).append("alignment", this.alignment).append("bgColor", (Object)this.bgColor).append("font", (Object)this.font).append("height", this.height).append("labelAddOns", this.labelAddOns).append("printIfAddOnEmpty", this.printIfAddOnEmpty).append("stateItem", (Object)this.stateItem).append("stateItemName", (Object)this.stateItemName).append("width", this.width).append("x", this.x).append("y", this.y).build();
    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            List elements = element.getChildren();
            ArrayList<ExpertLabelAddOn> labelAddOns = null;
            FontDTO font = null;
            for (Element subElement : elements) {
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof ExpertLabelAddOn) {
                        if (labelAddOns == null) {
                            labelAddOns = new ArrayList<ExpertLabelAddOn>();
                        }
                        labelAddOns.add((ExpertLabelAddOn)ref);
                        continue;
                    }
                    if (ref instanceof FontDTO) {
                        font = (FontDTO)ref;
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + String.valueOf(ref));
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), (Throwable)pnre);
                }
            }
            String key = element.getAttributeValue("key");
            if (key == null) {
                key = element.getAttributeValue("name");
            }
            if (key == null) {
                key = element.getAttributeValue("i18nKey");
            }
            ExpertLabelItem eli = new ExpertLabelItem(key, ExpertDisplayUtil.toPixel(element.getAttributeValue("x")), ExpertDisplayUtil.toPixel(element.getAttributeValue("y")), ExpertDisplayUtil.toPixel(element.getAttributeValue("width")), ExpertDisplayUtil.toPixel(element.getAttributeValue("height")), ExpertDisplayUtil.parseHAlignment(element.getAttributeValue("halign")), font, ExpertDisplayUtil.parseColor(element.getAttributeValue("bgColor")), labelAddOns, ExpertDisplayUtil.parseOutputMode(element.getAttributeValue("printItem")), ExpertDisplayUtil.getBoolean(element.getAttributeValue("inputItem"), true), ExpertDisplayUtil.parseLanguages(element.getAttributeValue("lang")), ExpertDisplayUtil.getBoolean(element.getAttributeValue("printIfAddOnEmpty"), true), element.getAttributeValue("state"));
            eli.setOriginalSettings(element.getAttributeValue("x"), element.getAttributeValue("y"), element.getAttributeValue("width"), element.getAttributeValue("height"));
            return new ClassObjectPair(ExpertFormDisplayModelItem.class, (Object)eli);
        }
    }
}

