/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.expertdisplay;

import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayUtil;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertFormItem;
import ch.dvbern.tax.common.engine.wizarddisplay.DisplayItemUniqueID;
import java.awt.geom.Point2D;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class ExpertDisplayModelItem {
    private DisplayItemUniqueID uniqueItemIdentifier;
    private final Set<String> languages;
    private final int printMode;
    private final boolean inputItem;
    private Point2D.Float originalPosition;
    private Point2D.Float originalSize;
    private ExpertDisplayModelItem parent;

    protected ExpertDisplayModelItem(Set<String> languages, int printMode, boolean inputItem) {
        this.languages = languages;
        this.printMode = printMode;
        this.inputItem = inputItem;
    }

    public abstract @Nullable List<? extends ExpertDisplayModelItem> getChildren();

    public final void initializeExpertDisplayModel(@NonNull Map<String, LogicModelItem> logicModelItems, @NonNull Map<String, ExpertFormItem> formItems, @NonNull String formId) throws InvalidModelException {
        Validate.notEmpty((CharSequence)formId);
        this.uniqueItemIdentifier = ExpertDisplayUtil.generateUniqueItemIdentifier(formId);
        this.additionalInitialization(logicModelItems, formItems);
        if (this.getChildren() != null) {
            for (ExpertDisplayModelItem expertDisplayModelItem : this.getChildren()) {
                expertDisplayModelItem.initializeExpertDisplayModel(logicModelItems, formItems, formId);
            }
        }
    }

    protected void additionalInitialization(Map<String, LogicModelItem> logicModelItems, Map<String, ExpertFormItem> navigationItems) throws InvalidModelException {
    }

    protected DisplayItemUniqueID getUniqueItemIdentifier() {
        return this.uniqueItemIdentifier;
    }

    public boolean isEnabledForLanguage(Locale locale) {
        if (this.languages == null || locale == null || locale.getLanguage() == null) {
            return true;
        }
        return this.languages.contains(locale.getLanguage());
    }

    public boolean isEnabledForMode(int mode) {
        if (mode == 1) {
            return this.inputItem;
        }
        return this.printMode != 0;
    }

    protected int getPrintMode() {
        return this.printMode;
    }

    protected boolean isInputItem() {
        return this.inputItem;
    }

    public Point2D.Float getOriginalPosition() {
        return this.originalPosition;
    }

    public Point2D.Float getOriginalSize() {
        return this.originalSize;
    }

    public ExpertDisplayModelItem getParent() {
        return this.parent;
    }

    protected void setParent(ExpertFormItem parent) {
        this.parent = parent;
    }

    public void setOriginalSettings(String x, String y, String width, String height) {
        try {
            this.originalPosition = new Point2D.Float(Float.parseFloat(x), Float.parseFloat(y));
            this.originalSize = new Point2D.Float(Float.parseFloat(width), Float.parseFloat(height));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

