/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.calcitems;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.util.FastStack;
import ch.dvbern.tax.common.integration.conf.ApplicationConfig;
import java.util.Calendar;
import java.util.Date;
import org.checkerframework.checker.nullness.qual.NonNull;

public class YearFromDate
implements CalcItem {
    @Override
    public void evaluate(@NonNull LogicModelItem.ProtectedMap model, @NonNull FastStack stack, @NonNull String dataModelKey) {
        if (stack.size() < 1) {
            throw new IllegalArgumentException("YearFromDate needs 1 element on stack");
        }
        Object value = stack.pop();
        if (value == null) {
            stack.push(null);
        } else if (value instanceof Date) {
            Calendar calendar = Calendar.getInstance(ApplicationConfig.TIMEZONE);
            calendar.setTime((Date)value);
            int year = calendar.get(1);
            stack.push(year);
        } else {
            throw new IllegalArgumentException("argument of YearFromDate need to be of type Date");
        }
    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            YearFromDate result = new YearFromDate();
            return new ClassObjectPair(YearFromDate.class, (Object)result);
        }
    }
}

