/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.calcitems;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.util.FastStack;
import org.apache.commons.text.StringEscapeUtils;
import org.checkerframework.checker.nullness.qual.NonNull;

public class Concat
implements CalcItem {
    private final String separator;

    public Concat(String separator) {
        this.separator = separator;
    }

    @Override
    public void evaluate(@NonNull LogicModelItem.ProtectedMap model, @NonNull FastStack stack, @NonNull String dataModelKey) {
        StringBuilder result = new StringBuilder();
        while (!stack.isEmpty()) {
            String str;
            Object value = stack.pop();
            if (value == null || (str = value.toString()).isEmpty()) continue;
            if (result.length() > 0 && this.separator != null && !this.separator.isEmpty()) {
                result.insert(0, this.separator);
            }
            result.insert(0, str);
        }
        stack.push(result.toString());
    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            String separator = element.getAttributeValue("separator");
            if (separator != null) {
                separator = StringEscapeUtils.unescapeJava((String)separator);
            }
            Concat result = new Concat(separator);
            return new ClassObjectPair(Concat.class, (Object)result);
        }
    }
}

