/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine;

import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.persistence.PersistenceHint;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class LogicModelItemInfoDTO
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final List<String> persistenceKeyTemplates;
    private final Set<String> listeners;
    private final Set<String> transitiveListeners;
    private final LogicModelItem.ImportProfile importProfile;
    private final PersistenceHint persistenceHint;

    private LogicModelItemInfoDTO(@NonNull String name, @NonNull List<String> persistenceKeyTemplates, @NonNull Set<String> listeners, @NonNull Set<String> transitiveListeners, @NonNull LogicModelItem.ImportProfile importProfile, @NonNull PersistenceHint persistenceHint) {
        this.name = Objects.requireNonNull(name);
        this.persistenceKeyTemplates = Collections.unmodifiableList(Objects.requireNonNull(persistenceKeyTemplates));
        this.listeners = Collections.unmodifiableSet(Objects.requireNonNull(listeners));
        Validate.isTrue((boolean)transitiveListeners.containsAll(listeners));
        this.transitiveListeners = Collections.unmodifiableSet(Objects.requireNonNull(transitiveListeners));
        this.importProfile = Objects.requireNonNull(importProfile);
        this.persistenceHint = Objects.requireNonNull(persistenceHint);
    }

    public @NonNull String getName() {
        return this.name;
    }

    public @NonNull List<String> getPersistenceKeyTemplates() {
        return this.persistenceKeyTemplates;
    }

    public @NonNull Set<String> getListeners() {
        return this.listeners;
    }

    public @NonNull Set<String> getTransitiveListeners() {
        return this.transitiveListeners;
    }

    public @NonNull LogicModelItem.ImportProfile getImportProfile() {
        return this.importProfile;
    }

    public @NonNull PersistenceHint getPersistenceHint() {
        return this.persistenceHint;
    }

    static Map<String, LogicModelItemInfoDTO> build(Map<String, LogicModelItem> logicModel) {
        assert (logicModel != null);
        HashMap<String, LogicModelItemInfoDTO> infoMap = new HashMap<String, LogicModelItemInfoDTO>(logicModel.size());
        for (LogicModelItem item : logicModel.values()) {
            HashSet<String> transitiveListeners = new HashSet<String>();
            LogicModelItemInfoDTO.gatherTransitiveListeners(item, transitiveListeners, logicModel);
            LogicModelItemInfoDTO info = new LogicModelItemInfoDTO(item.getName(), item.getPersistenceKeyTemplates(), new HashSet<String>(item.getListenersNames()), transitiveListeners, item.getImportProfile(), item.getPersistenceHint());
            infoMap.put(item.getName(), info);
        }
        return infoMap;
    }

    private static void gatherTransitiveListeners(LogicModelItem item, Set<String> transitiveListeners, Map<String, LogicModelItem> logicModel) {
        for (String listener : item.getListenersNames()) {
            if (transitiveListeners.contains(listener)) continue;
            transitiveListeners.add(listener);
            LogicModelItem listeningItem = Objects.requireNonNull(logicModel.get(listener), "Unknown listener: " + listener);
            LogicModelItemInfoDTO.gatherTransitiveListeners(listeningItem, transitiveListeners, logicModel);
        }
    }
}

