/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.lib.resource.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.modelitems.Module;
import ch.dvbern.tax.common.engine.util.LogicModelVisitor;
import ch.dvbern.tax.common.transfer.dto.PersistenceReadDTO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;

public class LogicModel {
    private List<Module> moduls = null;
    private List<LogicModelItem> topLevelItems = null;

    public LogicModel(List<LogicModelItem> topLevelItems) {
        if (topLevelItems == null) {
            throw new NullPointerException("Top level items list cannot be null.");
        }
        this.topLevelItems = topLevelItems;
        this.moduls = new ArrayList<Module>();
        for (LogicModelItem item : topLevelItems) {
            if (!(item instanceof Module)) continue;
            this.moduls.add((Module)item);
        }
    }

    public List<Module> getModuls() {
        return this.moduls;
    }

    public List<LogicModelItem> getTopLevelItems() {
        return this.topLevelItems;
    }

    public void initializeLogicModel(Map<String, LogicModelItem> logicModelItems, List<PersistenceReadDTO> persistenceReadDTOs, boolean verbose) throws InvalidModelException {
        HashMap<String, String> m = verbose ? new HashMap<String, String>() : null;
        Module prevModule = null;
        for (LogicModelItem lmi : this.topLevelItems) {
            prevModule = lmi.initializeLogicModel(logicModelItems, persistenceReadDTOs, "", 0, prevModule, m);
        }
    }

    public void initializeReferences(Map<String, LogicModelItem> logicModel) throws InvalidModelException {
        if (this.topLevelItems != null) {
            for (LogicModelItem lmi : this.topLevelItems) {
                lmi.initializeReferences(logicModel);
            }
        }
    }

    public void visit(@NonNull LogicModelVisitor visitor) {
        if (visitor == null) {
            throw new NullPointerException("Model visitor cannot be null.");
        }
        for (LogicModelItem item : this.topLevelItems) {
            this.visit(visitor, item);
        }
    }

    private void visit(LogicModelVisitor visitor, LogicModelItem item) {
        assert (visitor != null && item != null);
        visitor.accept(item);
        List<LogicModelItem> children = item.getChildren();
        if (children != null) {
            for (LogicModelItem child : children) {
                this.visit(visitor, child);
            }
        }
    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            List elements = element.getChildren();
            ArrayList<LogicModelItem> childItems = new ArrayList<LogicModelItem>(elements.size());
            for (Element subElement : elements) {
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof LogicModelItem) {
                        childItems.add((LogicModelItem)ref);
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + String.valueOf(ref));
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), (Throwable)pnre);
                }
            }
            return new ClassObjectPair(LogicModel.class, (Object)new LogicModel(childItems));
        }
    }
}

