/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine;

import ch.dvbern.tax.common.engine.LMK;
import ch.dvbern.tax.common.engine.LMKTreeNode;
import java.util.HashMap;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;

public class LMKTreeRoot {
    private final Map<LMK, LMKTreeNode> childTables = new HashMap<LMK, LMKTreeNode>();
    private final Map<LMK, LMK> childItems = new HashMap<LMK, LMK>();

    public LMKTreeNode putChildTable(@NonNull LMK tableLMK) {
        LMKTreeNode table = this.childTables.get(tableLMK);
        if (table == null) {
            table = new LMKTreeNode(tableLMK);
            this.childTables.put(tableLMK, table);
        }
        return table;
    }

    public void addChildItem(@NonNull LMK child) {
        LMK childLMK = this.childItems.get(child);
        if (childLMK == null) {
            this.childItems.put(child, child);
        }
    }

    public Map<LMK, LMKTreeNode> getChildTables() {
        return this.childTables;
    }

    public Map<LMK, LMK> getChildItems() {
        return this.childItems;
    }

    public LMKTreeNode findTableNode(@NonNull LMK tableLMK) {
        for (Map.Entry<LMK, LMKTreeNode> entry : this.childTables.entrySet()) {
            if (entry.getKey().equals(tableLMK)) {
                return entry.getValue();
            }
            entry.getValue().findTableNode(tableLMK);
        }
        return null;
    }
}

