/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine;

import ch.dvbern.tax.common.engine.LogicModel;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.PreselectionValidator;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.Validator;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayUtil;
import ch.dvbern.tax.common.engine.modelitems.Module;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpertUpdatePreprocessor {
    private static final Logger LOG = LoggerFactory.getLogger(ExpertUpdatePreprocessor.class);
    private final Map<String, LogicModelItem> logicModelItems;
    private final Map<String, PreselectionItem> preselectionItems = new HashMap<String, PreselectionItem>();
    private final Map<String, PreselectionItem> preselectionDependants = new HashMap<String, PreselectionItem>();

    public ExpertUpdatePreprocessor(LogicModel logicModel, Map<String, LogicModelItem> logicModelItems) {
        this.logicModelItems = logicModelItems;
        List<LogicModelItem> topLevelItems = logicModel.getTopLevelItems();
        if (topLevelItems != null) {
            for (LogicModelItem lmi : topLevelItems) {
                this.initializePreselectionItems(lmi);
            }
        }
    }

    private void initializePreselectionItems(LogicModelItem lmi) {
        List<Validator> validators = lmi.getValidators();
        List<LogicModelItem> children = lmi.getChildren();
        if (children != null) {
            for (LogicModelItem childLMI : children) {
                this.initializePreselectionItems(childLMI);
            }
        }
        if (!lmi.isReadonly() && !validators.isEmpty()) {
            for (Validator v : validators) {
                Reference preselectionReference;
                LogicModelItem preSel;
                PreselectionValidator preselectionValidator;
                if (!(v instanceof PreselectionValidator) || (preselectionValidator = (PreselectionValidator)((Object)v)).getPreselectItemReference() == null || !((preSel = this.logicModelItems.get((preselectionReference = preselectionValidator.getPreselectItemReference()).getName())) instanceof LogicModelItem.PreselectionItem) || preSel.isReadonly() || !((LogicModelItem.PreselectionItem)((Object)preSel)).isPreselectionItem()) continue;
                String key = preSel.getName() + preselectionValidator.getBooleanExpression();
                PreselectionItem pi = this.preselectionItems.get(key);
                if (pi == null) {
                    pi = new PreselectionItem(preSel, !preselectionValidator.getBooleanExpression());
                    this.preselectionItems.put(key, pi);
                }
                pi.addDependantItem(lmi);
                if (this.preselectionDependants.containsKey(lmi.getName())) {
                    LOG.warn("more than one preselection item for {}", (Object)lmi.getName());
                    continue;
                }
                this.preselectionDependants.put(lmi.getName(), pi);
            }
        }
    }

    public Map<String, ModelItemDTO> preProcessExpertUpdate(Map<String, ModelItemDTO> dataModel, Map<String, ModelItemDTO> newValues) {
        HashMap<String, ModelItemDTO> preUpdateValues = null;
        HashMap<String, ModelItemDTO> postUpdateValues = null;
        Iterator<Map.Entry<String, ModelItemDTO>> i1 = newValues.entrySet().iterator();
        while (i1.hasNext()) {
            Map.Entry<String, ModelItemDTO> me = i1.next();
            String currentDMK = me.getKey();
            PreselectionItem pi = this.findAnyPreselectionItem(currentDMK);
            if (pi == null) continue;
            ModelItemDTO miDTO = me.getValue();
            if (this.containsUserInput(miDTO)) {
                String dmk = EngineUtil.mergeModelKey(pi.getLogicModelItem().getName(), currentDMK);
                ModelItemDTO preSelectionDTO = new ModelItemDTO(pi.getEnabledValue());
                preSelectionDTO.setTouched();
                if (preUpdateValues == null) {
                    preUpdateValues = new HashMap<String, ModelItemDTO>();
                }
                preUpdateValues.put(dmk, preSelectionDTO);
                continue;
            }
            boolean existingOtherInput = false;
            Iterator<LogicModelItem> i2 = pi.getDependantItems().iterator();
            while (i2.hasNext() && !existingOtherInput) {
                LogicModelItem lmi = i2.next();
                existingOtherInput = this.containsUserInput(currentDMK, lmi, newValues, dataModel);
            }
            if (existingOtherInput) continue;
            String dmk = EngineUtil.mergeModelKey(pi.getLogicModelItem().getName(), currentDMK);
            ModelItemDTO preSelectionDTO = dataModel.get(dmk);
            Boolean preSelectionDisabled = !pi.getEnabledValue();
            if (preSelectionDTO == null || !preSelectionDisabled.equals(preSelectionDTO.getValue())) {
                preSelectionDTO = new ModelItemDTO(preSelectionDisabled);
                preSelectionDTO.setTouched();
                if (postUpdateValues == null) {
                    postUpdateValues = new HashMap<String, ModelItemDTO>();
                }
                postUpdateValues.put(dmk, preSelectionDTO);
                continue;
            }
            i1.remove();
        }
        if (preUpdateValues != null || postUpdateValues != null) {
            LinkedHashMap<String, ModelItemDTO> orderedNewValues = new LinkedHashMap<String, ModelItemDTO>();
            if (preUpdateValues != null) {
                orderedNewValues.putAll(preUpdateValues);
            }
            orderedNewValues.putAll(newValues);
            if (postUpdateValues != null) {
                orderedNewValues.putAll(postUpdateValues);
            }
            return orderedNewValues;
        }
        return newValues;
    }

    private boolean containsUserInput(String dmk, LogicModelItem lmi, Map<String, ModelItemDTO> newValues, Map<String, ModelItemDTO> dataModel) {
        String s = EngineUtil.mergeModelKey(lmi.getName(), dmk);
        if (lmi instanceof Module) {
            if (lmi.getChildren() == null) {
                return false;
            }
            for (LogicModelItem object : lmi.getChildren()) {
                if (!this.containsUserInput(dmk, object, newValues, dataModel)) continue;
                return true;
            }
        }
        if (lmi instanceof LogicModelItem.TableItem) {
            ModelItemDTO tDTO;
            if (EngineUtil.endsWithTableIndex(s)) {
                s = EngineUtil.removeLastKeyPart(s);
            }
            if ((tDTO = dataModel.get(s)) != null && tDTO.getValue() instanceof Set && !((Set)tDTO.getValue()).isEmpty()) {
                return true;
            }
            for (Map.Entry<String, ModelItemDTO> me : newValues.entrySet()) {
                if (!me.getKey().startsWith(s) || !this.containsUserInput(me.getValue())) continue;
                return true;
            }
        }
        if (lmi.isReadonly()) {
            return false;
        }
        ModelItemDTO tmp = newValues.get(s);
        if (tmp == null) {
            tmp = dataModel.get(s);
        }
        return this.containsUserInput(tmp);
    }

    private boolean containsUserInput(ModelItemDTO miDTO) {
        if (miDTO == null || miDTO.getValue() == null) {
            return false;
        }
        Object v = miDTO.getValue();
        if (v instanceof Collection) {
            return !((Collection)v).isEmpty();
        }
        return !v.toString().isEmpty();
    }

    private @Nullable PreselectionItem findAnyPreselectionItem(String dmk) {
        String s = EngineUtil.removeTableIndices(dmk);
        PreselectionItem pi = this.preselectionDependants.get(s);
        while (pi == null && s.indexOf(46) > 0) {
            s = EngineUtil.removeLastKeyPart(s);
            pi = this.preselectionDependants.get(s);
        }
        return pi;
    }

    public Map<String, ModelItemDTO> touchModelItems(@Nullable String formAccessKey, @Nullable List<? extends LogicModelItem> items, @Nullable Map<String, ModelItemDTO> dataModel) {
        HashMap<String, ModelItemDTO> result = new HashMap<String, ModelItemDTO>();
        if (formAccessKey == null || items == null || dataModel == null) {
            return result;
        }
        for (LogicModelItem logicModelItem : items) {
            Set unsortedRowIndices;
            if (logicModelItem instanceof Module && !logicModelItem.isImportantState()) continue;
            String dmk = ExpertDisplayUtil.getModelItemKey(logicModelItem, formAccessKey);
            ModelItemDTO miDTO = dataModel.get(dmk);
            boolean touchChildren = false;
            if (miDTO == null) {
                miDTO = new ModelItemDTO(null, 1);
                miDTO.setTouched();
                result.put(dmk, miDTO);
                touchChildren = true;
            } else if (miDTO.getState() == 3) {
                miDTO.setTouched();
                result.put(dmk, miDTO);
                touchChildren = true;
            } else if (miDTO.getState() == 4 || miDTO.getState() == 2) {
                touchChildren = true;
            }
            if (touchChildren && logicModelItem instanceof Module) {
                result.putAll(this.touchModelItems(formAccessKey, logicModelItem.getChildren(), dataModel));
                continue;
            }
            if (!touchChildren || !(logicModelItem instanceof LogicModelItem.TableItem) || (unsortedRowIndices = miDTO.getValue() != null ? (Set)miDTO.getValue() : null) == null || unsortedRowIndices.isEmpty()) continue;
            for (Object rowIndexObj : unsortedRowIndices) {
                String rowIndex = rowIndexObj.toString();
                Object fak = formAccessKey;
                if (((String)fak).indexOf(35) == -1) {
                    fak = (String)fak + "#";
                }
                fak = (String)fak + (((String)fak).endsWith("#") ? rowIndex : "." + rowIndex);
                result.putAll(this.touchModelItems((String)fak, logicModelItem.getChildren(), dataModel));
            }
        }
        return result;
    }

    private static class PreselectionItem {
        private final LogicModelItem logicModelItem;
        private final boolean enabledValue;
        private final List<LogicModelItem> dependantItems = new ArrayList<LogicModelItem>();

        public PreselectionItem(LogicModelItem logicModelItem, boolean enabledValue) {
            this.logicModelItem = logicModelItem;
            this.enabledValue = enabledValue;
        }

        public void addDependantItem(LogicModelItem lmi) {
            this.dependantItems.add(lmi);
        }

        public List<LogicModelItem> getDependantItems() {
            return this.dependantItems;
        }

        public boolean getEnabledValue() {
            return this.enabledValue;
        }

        public LogicModelItem getLogicModelItem() {
            return this.logicModelItem;
        }
    }
}

