/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Validator;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.engine.util.FastStack;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.Iterator;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugItem
implements CalcItem,
Validator {
    private static final Logger LOG = LoggerFactory.getLogger(DebugItem.class);
    private LogicModelItem lmi = null;
    private final String evaluate;
    private final boolean clearStack;
    private final boolean singleItem;
    private final String message;

    public DebugItem(String evaluate, boolean clearStack, boolean singleItem, String message) {
        this.evaluate = evaluate;
        this.clearStack = clearStack;
        this.singleItem = singleItem;
        this.message = message;
    }

    private static void doClearStack(FastStack stack) {
        while (!stack.isEmpty()) {
            stack.pop();
        }
    }

    @Override
    public void evaluate(@NonNull LogicModelItem.ProtectedMap dataModel, @NonNull FastStack stack, @NonNull String dataModelKey) {
        StringBuilder sb = new StringBuilder();
        sb.append(">>> DebugItem::evaluate(dataModel, stack, dataModelKey=").append(dataModelKey).append(")\n");
        sb.append("    stack: ");
        Iterator<Object> i = stack.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            sb.append(this.message == null ? "" : this.message);
            sb.append(o).append(" (").append(o == null ? "null" : o.getClass().getName()).append(')');
            if (this.singleItem) break;
            if (!i.hasNext()) continue;
            sb.append(", ");
        }
        sb.append('\n');
        this.logicModelItemEvaluation(dataModel, dataModelKey, sb);
        LOG.info(sb.toString());
        if (this.clearStack) {
            DebugItem.doClearStack(stack);
        }
    }

    @Override
    public void initializeReferences(@NonNull Map<String, LogicModelItem> logicModel, @NonNull LogicModelItem logicModelItem) throws InvalidModelException {
        this.lmi = logicModelItem;
    }

    @Override
    public @NonNull ModelItemDTO validate(@NonNull LogicModelItem.ProtectedMap dataModel, @NonNull String dataModelKey, @NonNull ModelItemDTO modelItemDTO) {
        StringBuilder sb = new StringBuilder();
        sb.append(">>> DebugItem::validate(dataModel, dataModelKey=").append(dataModelKey).append(", modelItemDTO)\n");
        sb.append("    LogicModelItem: ").append(this.lmi.getName()).append(" (").append(this.lmi.getClass().getName()).append(")\n");
        sb.append("    modelItemDTO: ");
        if (modelItemDTO == null) {
            sb.append("null");
        } else {
            Object value = modelItemDTO.getValue();
            sb.append("value=").append(value).append('(').append(value == null ? "null" : value.getClass().getName()).append(')').append(" state=").append(modelItemDTO.getState()).append(" touched=").append(modelItemDTO.isTouched());
        }
        sb.append('\n');
        this.logicModelItemEvaluation(dataModel, dataModelKey, sb);
        LOG.info(sb.toString());
        return modelItemDTO;
    }

    private void logicModelItemEvaluation(LogicModelItem.ProtectedMap dataModel, String dataModelKey, StringBuilder sb) {
        if (this.evaluate != null) {
            sb.append("    evaluation of ").append(this.evaluate).append(": ");
            ModelItemDTO modelItemDTO = dataModel.get(EngineUtil.mergeModelKey(this.evaluate, dataModelKey));
            if (modelItemDTO == null) {
                sb.append("null");
            } else {
                sb.append("value=").append(modelItemDTO.getValue()).append(" state=").append(modelItemDTO.getState()).append(" touched=").append(modelItemDTO.isTouched());
            }
            sb.append('\n');
            LOG.info(sb.toString());
        }
    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            return new ClassObjectPair(DebugItem.class, (Object)new DebugItem(element.getAttributeValue("evaluate"), Boolean.parseBoolean(element.getAttributeValue("clearStack")), Boolean.parseBoolean(element.getAttributeValue("single")), element.getAttributeValue("msg")));
        }
    }
}

