/*
 * Decompiled with CFR 0.152.
 */
package com.github.markusbernhardt.proxy.selector.pac;

import com.github.markusbernhardt.proxy.selector.pac.JavaxPacScriptParser;
import com.github.markusbernhardt.proxy.selector.pac.ScriptMethods;
import com.github.markusbernhardt.proxy.util.Logger;
import java.io.IOException;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.TreeMap;

public class PacScriptMethods
implements ScriptMethods {
    public static final String OVERRIDE_LOCAL_IP = "com.btr.proxy.pac.overrideLocalIP";
    private String ipAddress = null;
    private String ipAddressEx = null;
    private static final String GMT = "GMT";
    private static final List<String> DAYS = Collections.unmodifiableList(Arrays.asList("SUN", "MON", "TUE", "WED", "THU", "FRI", "SAT"));
    private static final List<String> MONTH = Collections.unmodifiableList(Arrays.asList("JAN", "FEB", "MAR", "APR", "MAY", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV", "DEC"));
    private static final String DAY1 = "day1";
    private static final String DAY2 = "day2";
    private static final String MONTH1 = "month1";
    private static final String MONTH2 = "month2";
    private static final String YEAR1 = "year1";
    private static final String YEAR2 = "year2";
    private Calendar currentTime;
    private static final BigInteger HIGH_32_INT = new BigInteger(new byte[]{-1, -1, -1, -1});
    private static final BigInteger HIGH_128_INT = new BigInteger(new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1});

    @Override
    public boolean isPlainHostName(String host) {
        return host.indexOf(".") < 0;
    }

    @Override
    public boolean dnsDomainIs(String host, String domain) {
        return host.endsWith(domain);
    }

    @Override
    public boolean localHostOrDomainIs(String host, String domain) {
        return domain.startsWith(host);
    }

    @Override
    public boolean isResolvable(String host) {
        try {
            InetAddress.getByName(host).getHostAddress();
            return true;
        }
        catch (UnknownHostException ex) {
            Logger.log(JavaxPacScriptParser.class, Logger.LogLevel.DEBUG, "Hostname not resolveable {}.", host);
            return false;
        }
    }

    @Override
    public boolean isInNet(String host, String pattern, String mask) {
        if ((host = this.dnsResolve(host)) == null || host.length() == 0) {
            return false;
        }
        long lhost = this.parseIpAddressToLong(host);
        long lpattern = this.parseIpAddressToLong(pattern);
        long lmask = this.parseIpAddressToLong(mask);
        return (lhost & lmask) == lpattern;
    }

    private long parseIpAddressToLong(String address) {
        long result = 0L;
        String[] parts = address.split("\\.");
        long shift = 24L;
        for (String part : parts) {
            long lpart = Long.parseLong(part.trim());
            result |= lpart << (int)shift;
            shift -= 8L;
        }
        return result;
    }

    @Override
    public String dnsResolve(String host) {
        try {
            InetAddress ina = InetAddress.getByName(host);
            return ina.getHostAddress();
        }
        catch (UnknownHostException e) {
            Logger.log(JavaxPacScriptParser.class, Logger.LogLevel.DEBUG, "DNS name not resolvable {}.", host);
            return "";
        }
    }

    @Override
    public String myIpAddress() {
        if (this.ipAddress == null || this.ipAddress.isEmpty()) {
            this.ipAddress = this.getLocalAddressOfType(Inet4Address.class);
        }
        return this.ipAddress;
    }

    private String getLocalAddressOfType(Class<? extends InetAddress> cl) {
        try {
            String overrideIP = System.getProperty(OVERRIDE_LOCAL_IP);
            if (overrideIP != null && overrideIP.trim().length() > 0) {
                return overrideIP.trim();
            }
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            ArrayList<InetAddress> localAddresses = new ArrayList<InetAddress>();
            while (interfaces.hasMoreElements()) {
                NetworkInterface current = interfaces.nextElement();
                if (!current.isUp() || current.isLoopback() || current.isVirtual()) continue;
                Enumeration<InetAddress> addresses = current.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress adr = addresses.nextElement();
                    if (!cl.isInstance(adr)) continue;
                    localAddresses.add(adr);
                }
            }
            if (localAddresses.isEmpty()) {
                return "";
            }
            InetAddress localAddress = (InetAddress)localAddresses.get(0);
            if (localAddresses.size() > 1) {
                InetAddress localHost;
                if (Inet4Address.class.equals(cl)) {
                    localHost = Inet4Address.getLocalHost();
                    if (localAddresses.contains(localHost)) {
                        localAddress = localHost;
                    }
                } else if (Inet6Address.class.equals(cl) && localAddresses.contains(localHost = Inet6Address.getLocalHost())) {
                    localAddress = localHost;
                }
            }
            Logger.log(JavaxPacScriptParser.class, Logger.LogLevel.TRACE, "Local address resolved to {}", localAddress);
            return localAddress.getHostAddress();
        }
        catch (IOException e) {
            Logger.log(JavaxPacScriptParser.class, Logger.LogLevel.DEBUG, "Local address not resolvable.", new Object[0]);
            return "";
        }
    }

    @Override
    public int dnsDomainLevels(String host) {
        int count = 0;
        int startPos = 0;
        while ((startPos = host.indexOf(".", startPos + 1)) > -1) {
            ++count;
        }
        return count;
    }

    @Override
    public boolean shExpMatch(String str, String shexp) {
        StringTokenizer tokenizer = new StringTokenizer(shexp, "*");
        int startPos = 0;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            int temp = str.indexOf(token, startPos);
            if (startPos == 0 && !shexp.startsWith("*") && temp != 0) {
                return false;
            }
            if (!(tokenizer.hasMoreTokens() || shexp.endsWith("*") || str.endsWith(token))) {
                return false;
            }
            if (temp == -1) {
                return false;
            }
            startPos = temp + token.length();
        }
        return true;
    }

    @Override
    public boolean weekdayRange(String wd1, String wd2, String gmt) {
        boolean useGmt = GMT.equalsIgnoreCase(wd2) || GMT.equalsIgnoreCase(gmt);
        Calendar cal = this.getCurrentTime(useGmt);
        int currentDay = cal.get(7) - 1;
        int from = DAYS.indexOf(wd1 == null ? null : wd1.toUpperCase());
        int to = DAYS.indexOf(wd2 == null ? null : wd2.toUpperCase());
        if (to == -1) {
            to = from;
        }
        if (to < from) {
            return currentDay >= from || currentDay <= to;
        }
        return currentDay >= from && currentDay <= to;
    }

    public void setCurrentTime(Calendar cal) {
        this.currentTime = cal;
    }

    private Calendar getCurrentTime(boolean useGmt) {
        if (this.currentTime != null) {
            return (Calendar)this.currentTime.clone();
        }
        return Calendar.getInstance(useGmt ? TimeZone.getTimeZone(GMT) : TimeZone.getDefault());
    }

    @Override
    public boolean dateRange(Object day1, Object month1, Object year1, Object day2, Object month2, Object year2, Object gmt) {
        Date to;
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        this.parseDateParam(params, day1);
        this.parseDateParam(params, month1);
        this.parseDateParam(params, year1);
        this.parseDateParam(params, day2);
        this.parseDateParam(params, month2);
        this.parseDateParam(params, year2);
        this.parseDateParam(params, gmt);
        boolean useGmt = params.get("gmt") != null;
        Calendar cal = this.getCurrentTime(useGmt);
        Date current = cal.getTime();
        if (params.get(DAY1) != null) {
            cal.set(5, (Integer)params.get(DAY1));
        }
        if (params.get(MONTH1) != null) {
            cal.set(2, (Integer)params.get(MONTH1));
        }
        if (params.get(YEAR1) != null) {
            cal.set(1, (Integer)params.get(YEAR1));
        }
        Date from = cal.getTime();
        if (params.get(DAY2) != null) {
            cal.set(5, (Integer)params.get(DAY2));
        }
        if (params.get(MONTH2) != null) {
            cal.set(2, (Integer)params.get(MONTH2));
        }
        if (params.get(YEAR2) != null) {
            cal.set(1, (Integer)params.get(YEAR2));
        }
        if ((to = cal.getTime()).before(from)) {
            cal.add(2, 1);
            to = cal.getTime();
        }
        if (to.before(from)) {
            cal.add(1, 1);
            cal.add(2, -1);
            to = cal.getTime();
        }
        return current.compareTo(from) >= 0 && current.compareTo(to) <= 0;
    }

    private void parseDateParam(Map<String, Integer> params, Object value) {
        int n;
        if (value instanceof Number) {
            n = ((Number)value).intValue();
            if (n <= 31) {
                if (params.get(DAY1) == null) {
                    params.put(DAY1, n);
                } else {
                    params.put(DAY2, n);
                }
            } else if (params.get(YEAR1) == null) {
                params.put(YEAR1, n);
            } else {
                params.put(YEAR2, n);
            }
        }
        if (value instanceof String && (n = MONTH.indexOf(((String)value).toUpperCase())) > -1) {
            if (params.get(MONTH1) == null) {
                params.put(MONTH1, n);
            } else {
                params.put(MONTH2, n);
            }
        }
        if (GMT.equalsIgnoreCase(String.valueOf(value))) {
            params.put("gmt", 1);
        }
    }

    @Override
    public boolean timeRange(Object hour1, Object min1, Object sec1, Object hour2, Object min2, Object sec2, Object gmt) {
        Date to;
        Date from;
        boolean useGmt = GMT.equalsIgnoreCase(String.valueOf(min1)) || GMT.equalsIgnoreCase(String.valueOf(sec1)) || GMT.equalsIgnoreCase(String.valueOf(min2)) || GMT.equalsIgnoreCase(String.valueOf(gmt));
        Calendar cal = this.getCurrentTime(useGmt);
        cal.set(14, 0);
        Date current = cal.getTime();
        if (sec2 instanceof Number) {
            cal.set(11, ((Number)hour1).intValue());
            cal.set(12, ((Number)min1).intValue());
            cal.set(13, ((Number)sec1).intValue());
            from = cal.getTime();
            cal.set(11, ((Number)hour2).intValue());
            cal.set(12, ((Number)min2).intValue());
            cal.set(13, ((Number)sec2).intValue());
            to = cal.getTime();
        } else if (hour2 instanceof Number) {
            cal.set(11, ((Number)hour1).intValue());
            cal.set(12, ((Number)min1).intValue());
            cal.set(13, 0);
            from = cal.getTime();
            cal.set(11, ((Number)sec1).intValue());
            cal.set(12, ((Number)hour2).intValue());
            cal.set(13, 59);
            to = cal.getTime();
        } else if (min1 instanceof Number) {
            cal.set(11, ((Number)hour1).intValue());
            cal.set(12, 0);
            cal.set(13, 0);
            from = cal.getTime();
            cal.set(11, ((Number)min1).intValue());
            cal.set(12, 59);
            cal.set(13, 59);
            to = cal.getTime();
        } else {
            cal.set(11, ((Number)hour1).intValue());
            cal.set(12, 0);
            cal.set(13, 0);
            from = cal.getTime();
            cal.set(11, ((Number)hour1).intValue());
            cal.set(12, 59);
            cal.set(13, 59);
            to = cal.getTime();
        }
        if (to.before(from)) {
            cal.setTime(to);
            cal.add(5, 1);
            to = cal.getTime();
        }
        return current.compareTo(from) >= 0 && current.compareTo(to) <= 0;
    }

    @Override
    public boolean isResolvableEx(String host) {
        return this.isResolvable(host);
    }

    @Override
    public boolean isInNetEx(String ipOrHost, String cidr) {
        if (ipOrHost == null || ipOrHost.length() == 0 || cidr == null || cidr.length() == 0) {
            return false;
        }
        try {
            String[] cidrParts = cidr.split("/");
            if (cidrParts.length != 2) {
                return false;
            }
            String cidrRange = cidrParts[0];
            int cidrBits = Integer.parseInt(cidrParts[1]);
            byte[] addressBytes = InetAddress.getByName(ipOrHost).getAddress();
            BigInteger ip = new BigInteger(addressBytes);
            BigInteger mask = addressBytes.length == 4 ? HIGH_32_INT.shiftLeft(32 - cidrBits) : HIGH_128_INT.shiftLeft(128 - cidrBits);
            byte[] rangeBytes = InetAddress.getByName(cidrRange).getAddress();
            BigInteger range = new BigInteger(rangeBytes);
            BigInteger lowIP = range.and(mask);
            BigInteger highIP = lowIP.add(mask.not());
            return lowIP.compareTo(ip) <= 0 && highIP.compareTo(ip) >= 0;
        }
        catch (UnknownHostException e) {
            return false;
        }
    }

    @Override
    public String dnsResolveEx(String host) {
        StringBuilder result = new StringBuilder();
        try {
            InetAddress[] list;
            for (InetAddress inetAddress : list = InetAddress.getAllByName(host)) {
                result.append(inetAddress.getHostAddress());
                result.append("; ");
            }
        }
        catch (UnknownHostException e) {
            Logger.log(JavaxPacScriptParser.class, Logger.LogLevel.DEBUG, "DNS name not resolvable {}.", host);
        }
        return result.toString();
    }

    @Override
    public String myIpAddressEx() {
        if (this.ipAddressEx == null || this.ipAddressEx.isEmpty()) {
            this.ipAddressEx = this.getLocalAddressOfType(Inet6Address.class);
        }
        return this.ipAddressEx;
    }

    @Override
    public String sortIpAddressList(String ipAddressList) {
        if (ipAddressList == null || ipAddressList.trim().length() == 0) {
            return "";
        }
        try {
            String[] ipAddressToken = ipAddressList.split(";");
            TreeMap<byte[], String> sorting = new TreeMap<byte[], String>(new Comparator<byte[]>(){

                @Override
                public int compare(byte[] b1, byte[] b2) {
                    if (b1.length != b2.length) {
                        return b2.length - b1.length;
                    }
                    return new BigInteger(b1).compareTo(new BigInteger(b2));
                }
            });
            for (String ip : ipAddressToken) {
                String cleanIP = ip.trim();
                sorting.put(InetAddress.getByName(cleanIP).getAddress(), cleanIP);
            }
            StringBuilder result = new StringBuilder();
            for (String ip : sorting.values()) {
                if (result.length() > 0) {
                    result.append(";");
                }
                result.append(ip);
            }
            return result.toString();
        }
        catch (Exception e) {
            Logger.log(JavaxPacScriptParser.class, Logger.LogLevel.DEBUG, "Cannot sort invalid IP list: {}.", ipAddressList);
            return "";
        }
    }

    @Override
    public String getClientVersion() {
        return "1.0";
    }
}

