/*
 * Decompiled with CFR 0.152.
 */
package com.github.markusbernhardt.proxy;

import com.github.markusbernhardt.proxy.ProxySearchStrategy;
import com.github.markusbernhardt.proxy.search.browser.firefox.FirefoxProxySearchStrategy;
import com.github.markusbernhardt.proxy.search.browser.ie.IEProxySearchStrategy;
import com.github.markusbernhardt.proxy.search.desktop.DesktopProxySearchStrategy;
import com.github.markusbernhardt.proxy.search.desktop.gnome.GnomeDConfProxySearchStrategy;
import com.github.markusbernhardt.proxy.search.desktop.gnome.GnomeProxySearchStrategy;
import com.github.markusbernhardt.proxy.search.desktop.kde.KdeProxySearchStrategy;
import com.github.markusbernhardt.proxy.search.desktop.win.WinProxySearchStrategy;
import com.github.markusbernhardt.proxy.search.env.EnvProxySearchStrategy;
import com.github.markusbernhardt.proxy.search.java.JavaProxySearchStrategy;
import com.github.markusbernhardt.proxy.search.wpad.WpadProxySearchStrategy;
import com.github.markusbernhardt.proxy.selector.misc.BufferedProxySelector;
import com.github.markusbernhardt.proxy.selector.misc.ProxyListFallbackSelector;
import com.github.markusbernhardt.proxy.selector.pac.PacProxySelector;
import com.github.markusbernhardt.proxy.util.Logger;
import com.github.markusbernhardt.proxy.util.PlatformUtil;
import com.github.markusbernhardt.proxy.util.ProxyException;
import java.awt.GraphicsEnvironment;
import java.net.ProxySelector;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.slf4j.helpers.MessageFormatter;

public class ProxySearch
implements ProxySearchStrategy {
    private static final int DEFAULT_PAC_CACHE_SIZE = 20;
    private static final long DEFAULT_PAC_CACHE_TTL = 600000L;
    private static final BufferedProxySelector.CacheScope DEFAULT_PAC_CACHE_SCOPE = BufferedProxySelector.CacheScope.CACHE_SCOPE_HOST;
    private List<ProxySearchStrategy> strategies = new ArrayList<ProxySearchStrategy>();
    private int pacCacheSize = 20;
    private long pacCacheTTL = 600000L;
    private BufferedProxySelector.CacheScope pacCacheScope = DEFAULT_PAC_CACHE_SCOPE;

    public static ProxySearch getDefaultProxySearch() {
        ProxySearch s = new ProxySearch();
        boolean headless = GraphicsEnvironment.isHeadless();
        if (headless) {
            s.addStrategy(Strategy.JAVA);
            s.addStrategy(Strategy.OS_DEFAULT);
            s.addStrategy(Strategy.ENV_VAR);
        } else {
            s.addStrategy(Strategy.JAVA);
            s.addStrategy(Strategy.BROWSER);
            s.addStrategy(Strategy.OS_DEFAULT);
            s.addStrategy(Strategy.ENV_VAR);
        }
        Logger.log(ProxySearch.class, Logger.LogLevel.TRACE, "Using default search priority: {}", s);
        return s;
    }

    public void addStrategy(Strategy strategy) {
        switch (strategy.ordinal()) {
            case 0: {
                this.strategies.add(new DesktopProxySearchStrategy());
                break;
            }
            case 1: {
                this.strategies.add(new WpadProxySearchStrategy());
                break;
            }
            case 2: {
                this.strategies.add(this.getDefaultBrowserStrategy());
                break;
            }
            case 3: {
                this.strategies.add(new FirefoxProxySearchStrategy());
                break;
            }
            case 4: {
                this.strategies.add(new IEProxySearchStrategy());
                break;
            }
            case 5: {
                this.strategies.add(new EnvProxySearchStrategy());
                break;
            }
            case 6: {
                this.strategies.add(new WinProxySearchStrategy());
                break;
            }
            case 7: {
                this.strategies.add(new KdeProxySearchStrategy());
                break;
            }
            case 8: {
                this.strategies.add(new GnomeDConfProxySearchStrategy());
                this.strategies.add(new GnomeProxySearchStrategy());
                break;
            }
            case 9: {
                this.strategies.add(new JavaProxySearchStrategy());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown strategy code!");
            }
        }
    }

    public void addStrategy(ProxySearchStrategy customStrategy, boolean addAsFirst) {
        if (customStrategy == null) {
            throw new IllegalArgumentException("No custom search strategy provided!");
        }
        if (addAsFirst) {
            this.strategies.add(0, customStrategy);
        } else {
            this.strategies.add(customStrategy);
        }
    }

    public void removeStrategy(Strategy strategy) {
        block0 : switch (strategy.ordinal()) {
            case 0: {
                this.removeStrategy((ProxySearchStrategy pss) -> pss instanceof DesktopProxySearchStrategy);
                break;
            }
            case 1: {
                this.removeStrategy((ProxySearchStrategy pss) -> pss instanceof WpadProxySearchStrategy);
                break;
            }
            case 2: {
                switch (PlatformUtil.getDefaultBrowser()) {
                    case IE: {
                        this.removeStrategy((ProxySearchStrategy pss) -> pss instanceof IEProxySearchStrategy);
                        break block0;
                    }
                    case FIREFOX: {
                        this.removeStrategy((ProxySearchStrategy pss) -> pss instanceof FirefoxProxySearchStrategy);
                        break block0;
                    }
                }
                break;
            }
            case 4: {
                this.removeStrategy((ProxySearchStrategy pss) -> pss instanceof IEProxySearchStrategy);
                break;
            }
            case 3: {
                this.removeStrategy((ProxySearchStrategy pss) -> pss instanceof FirefoxProxySearchStrategy);
                break;
            }
            case 5: {
                this.removeStrategy((ProxySearchStrategy pss) -> pss instanceof EnvProxySearchStrategy);
                break;
            }
            case 6: {
                this.removeStrategy((ProxySearchStrategy pss) -> pss instanceof WinProxySearchStrategy);
                break;
            }
            case 7: {
                this.removeStrategy((ProxySearchStrategy pss) -> pss instanceof KdeProxySearchStrategy);
                break;
            }
            case 8: {
                this.removeStrategy((ProxySearchStrategy pss) -> pss instanceof GnomeDConfProxySearchStrategy);
                this.removeStrategy((ProxySearchStrategy pss) -> pss instanceof GnomeProxySearchStrategy);
                break;
            }
            case 9: {
                this.removeStrategy((ProxySearchStrategy pss) -> pss instanceof JavaProxySearchStrategy);
                break;
            }
        }
    }

    private void removeStrategy(Predicate<ProxySearchStrategy> filter) {
        ProxySearchStrategy proxySeachStrategy = this.strategies.stream().filter(filter).findFirst().orElse(null);
        if (proxySeachStrategy != null) {
            this.strategies.remove(proxySeachStrategy);
        }
    }

    public void setPacCacheSettings(int size, long ttl, BufferedProxySelector.CacheScope cacheScope) {
        this.pacCacheSize = size;
        this.pacCacheTTL = ttl;
        this.pacCacheScope = cacheScope;
    }

    private ProxySearchStrategy getDefaultBrowserStrategy() {
        switch (PlatformUtil.getDefaultBrowser()) {
            case IE: {
                return new IEProxySearchStrategy();
            }
            case FIREFOX: {
                return new FirefoxProxySearchStrategy();
            }
        }
        return null;
    }

    @Override
    public ProxySelector getProxySelector() {
        Logger.log(this.getClass(), Logger.LogLevel.TRACE, "Executing search strategies to find proxy selector", new Object[0]);
        for (ProxySearchStrategy strat : this.strategies) {
            try {
                ProxySelector selector = strat.getProxySelector();
                if (selector != null) {
                    selector = this.installBufferingAndFallbackBehaviour(selector);
                    Logger.log(this.getClass(), Logger.LogLevel.INFO, "Proxy found for " + strat.getName(), new Object[0]);
                    return selector;
                }
                Logger.log(this.getClass(), Logger.LogLevel.INFO, "No proxy found for " + strat.getName() + ". Trying next one.", new Object[0]);
            }
            catch (ProxyException e) {
                Logger.log(this.getClass(), Logger.LogLevel.DEBUG, "Strategy {} failed trying next one.", e);
            }
        }
        return null;
    }

    @Override
    public String getName() {
        return "default";
    }

    private ProxySelector installBufferingAndFallbackBehaviour(ProxySelector selector) {
        if (selector instanceof PacProxySelector) {
            if (this.pacCacheSize > 0) {
                selector = new BufferedProxySelector(this.pacCacheSize, this.pacCacheTTL, selector, this.pacCacheScope);
            }
            selector = new ProxyListFallbackSelector(selector);
        }
        return selector;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Proxy search: ");
        for (ProxySearchStrategy strat : this.strategies) {
            sb.append(strat);
            sb.append(" ");
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        ProxySearch ps = ProxySearch.getDefaultProxySearch();
        Logger.setBackend(new Logger.LogBackEnd(){

            @Override
            public void log(Class<?> clazz, Logger.LogLevel loglevel, String msg, Object ... params) {
                System.out.println(MessageFormatter.format((String)msg, (Object)params).getMessage());
            }
        });
        ps.getProxySelector();
    }

    public static enum Strategy {
        OS_DEFAULT,
        WPAD,
        BROWSER,
        FIREFOX,
        IE,
        ENV_VAR,
        WIN,
        KDE,
        GNOME,
        JAVA;

    }
}

