/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.lib.update.type;

import ch.dvbern.lib.update.IOUtils;
import ch.dvbern.lib.update.SecureDownloader;
import ch.dvbern.lib.update.UpdateProvider;
import ch.dvbern.lib.update.exception.CauseType;
import ch.dvbern.lib.update.exception.UpdateFailureException;
import ch.dvbern.lib.update.signatures.SignMethod;
import ch.dvbern.lib.update.signatures.SignatureVerifier;
import ch.dvbern.lib.update.signatures.TrustManagerProvider;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Objects;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class UpdateConfig
implements UpdateProvider {
    protected static final Logger LOG = Logger.getLogger(UpdateConfig.class.getName());
    @Nonnull
    private final String protocol;
    @Nonnull
    private final String server;
    private final int port;
    @Nonnull
    private final String path;
    @Nonnull
    private final String signatureFileSuffix;
    @Nonnull
    private final SignatureVerifier signatureVerifier;
    @Nonnull
    private final TrustManagerProvider trustManagerProvider;

    public UpdateConfig(@Nonnull String protocol, @Nonnull String server, int port, @Nonnull String path, @Nonnull SignatureVerifier signatureVerifier, @Nonnull TrustManagerProvider trustManagerProvider, @Nonnull String signatureFileSuffix) {
        this.protocol = Objects.requireNonNull(protocol);
        this.server = Objects.requireNonNull(server);
        this.port = port;
        if (port <= 0) {
            throw new IllegalArgumentException("Port must be > 0, actual: " + port);
        }
        this.path = Objects.requireNonNull(path);
        this.signatureVerifier = Objects.requireNonNull(signatureVerifier);
        this.trustManagerProvider = Objects.requireNonNull(trustManagerProvider);
        this.signatureFileSuffix = Objects.requireNonNull(signatureFileSuffix);
    }

    @Deprecated
    public UpdateConfig(@Nonnull String protocol, @Nonnull String server, int port, @Nonnull String path, @Nonnull SignatureVerifier signatureVerifier, @Nonnull TrustManagerProvider trustManagerProvider) {
        this(protocol, server, port, path, signatureVerifier, trustManagerProvider, ".dsig");
    }

    @Nonnull
    public String getProtocol() {
        return this.protocol;
    }

    @Nonnull
    public String getServer() {
        return this.server;
    }

    public int getPort() {
        return this.port;
    }

    @Nonnull
    public String getPath() {
        return this.path;
    }

    @Override
    @Nonnull
    public InputStream getUpdateSite() throws UpdateFailureException {
        return this.verifiedDownload("update-site.xml", new SecureDownloader(){

            @Override
            @Nonnull
            public InputStream downloadSecure(@Nonnull URL baseFile, SignMethod signMethod) throws IOException {
                return UpdateConfig.this.downloadSecure(baseFile, signMethod);
            }
        });
    }

    private InputStream verifiedDownload(String fileName, SecureDownloader secureDownloader) throws UpdateFailureException {
        URL url = this.buildURL(fileName);
        byte[] bytes = this.download(url);
        this.signatureVerifier.verify(url, bytes, secureDownloader);
        ByteArrayInputStream result = new ByteArrayInputStream(bytes);
        return result;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private byte[] download(URL url) throws UpdateFailureException {
        try (InputStream in = this.getFileStream(url);){
            byte[] byArray;
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                IOUtils.copy(in, baos);
                byArray = baos.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new UpdateFailureException(CauseType.SERVER, "Error downloading: " + url, e);
        }
    }

    @Override
    @Nonnull
    public InputStream getFile(@Nonnull String relativePath) throws IOException {
        Objects.requireNonNull(relativePath);
        URL url = this.buildURL(relativePath);
        return this.getFileStream(url);
    }

    private InputStream getFileStream(@Nonnull URL url) throws IOException {
        LOG.info("downloading: " + url);
        URLConnection urlConnection = url.openConnection();
        this.setupCertificatePinning(urlConnection);
        urlConnection.setAllowUserInteraction(false);
        urlConnection.setUseCaches(false);
        urlConnection.connect();
        return urlConnection.getInputStream();
    }

    private void setupCertificatePinning(@Nonnull URLConnection urlConnection) {
        if (!"https".equalsIgnoreCase(this.protocol)) {
            LOG.severe("Not a HTTPS connection to: " + urlConnection.getURL());
            return;
        }
        if (!(urlConnection instanceof HttpsURLConnection)) {
            throw new IllegalStateException("protocol https but no HttpsURLConnection");
        }
        HttpsURLConnection httpsURLConnection = (HttpsURLConnection)urlConnection;
        try {
            SSLSocketFactory sslSocketFactory = this.createPinnedSSLSocketFactory();
            httpsURLConnection.setSSLSocketFactory(sslSocketFactory);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not setup certificate pinning", e);
        }
    }

    @Nonnull
    private SSLSocketFactory createPinnedSSLSocketFactory() throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sslContext = SSLContext.getInstance("TLS");
        TrustManager[] trustManagers = this.trustManagerProvider.getTrustManagers();
        sslContext.init(null, trustManagers, new SecureRandom());
        return sslContext.getSocketFactory();
    }

    @Override
    @Nonnull
    public InputStream downloadSecure(@Nonnull URL baseFile, SignMethod signMethod) throws IOException {
        Objects.requireNonNull(baseFile);
        Objects.requireNonNull(signMethod);
        return this.getFileStream(this.buildSignedDigestPath(baseFile, signMethod));
    }

    @Override
    @Nonnull
    public SignatureVerifier getSignatureVerifier() {
        return this.signatureVerifier;
    }

    @Nonnull
    public TrustManagerProvider getTrustManagerProvider() {
        return this.trustManagerProvider;
    }

    @Override
    @Nonnull
    public URL buildURL(@Nonnull String siteRelativePath) throws IllegalArgumentException {
        URL url;
        URI uri;
        Objects.requireNonNull(siteRelativePath);
        try {
            uri = new URI(this.protocol, null, this.server, this.port, this.path + siteRelativePath, null, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Cannot build a valid url using " + siteRelativePath, e);
        }
        try {
            url = uri.toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Cannot build a valid url using " + siteRelativePath, e);
        }
        return url;
    }

    @Nonnull
    private URL buildSignedDigestPath(URL baseFile, SignMethod signMethod) {
        Objects.requireNonNull(baseFile);
        Objects.requireNonNull(signMethod);
        String fileExtension = "." + signMethod.getAlgorithmName() + this.getSignatureFileSuffix();
        URL result = IOUtils.extendURL(baseFile, fileExtension);
        return result;
    }

    @Override
    @Nonnull
    public String getSignatureFileSuffix() {
        return this.signatureFileSuffix;
    }
}

