/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.lib.update.elevate.cocoa;

import ch.dvbern.lib.update.IOUtils;
import ch.dvbern.lib.update.OsUtil;
import ch.dvbern.lib.update.elevate.ElevationFailedException;
import ch.dvbern.lib.update.elevate.PriviligesElevatorBase;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CocoaSudoPrivilegesElevator
extends PriviligesElevatorBase {
    private static final Logger LOG = Logger.getLogger(CocoaSudoPrivilegesElevator.class.getName());
    private static final String PROGRAM_RESOURCE_NAME = "cocoasudo";

    @Override
    public boolean supportsCurrentSystem() {
        return OsUtil.isOsMac();
    }

    @Override
    public boolean processExitCode(int code) throws ElevationFailedException {
        if (code != 0) {
            throw new ElevationFailedException("Non-zero error code returned by elevation utility: " + code);
        }
        return true;
    }

    @Override
    protected String[] getHelperCommand(String prompt, String icon) {
        File helperProgram;
        try {
            helperProgram = this.extractHelperResource(PROGRAM_RESOURCE_NAME);
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Failed to extract helper program", e);
            return null;
        }
        IOUtils.markExecutable(helperProgram);
        ArrayList<Object> helperCommand = new ArrayList<Object>(3);
        helperCommand.add(helperProgram.getAbsolutePath());
        if (prompt != null && !prompt.trim().isEmpty()) {
            helperCommand.add("--prompt=" + prompt);
        }
        if (icon != null && !icon.trim().isEmpty()) {
            helperCommand.add("--icon=" + icon);
        }
        return helperCommand.toArray(new String[helperCommand.size()]);
    }
}

