/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.lib.update.elevate;

import ch.dvbern.lib.update.IOUtils;
import ch.dvbern.lib.update.elevate.ElevationFailedException;
import ch.dvbern.lib.update.elevate.IPrivilegesElevator;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.MissingResourceException;
import java.util.logging.Logger;

public abstract class PriviligesElevatorBase
implements IPrivilegesElevator {
    private static final Logger LOG = Logger.getLogger(PriviligesElevatorBase.class.getName());

    @Override
    public ProcessBuilder createElevatedProcessBuilder(String[] command, String prompt, String icon) throws ElevationFailedException {
        if (command == null) {
            throw new NullPointerException("command cannot be null");
        }
        if (command.length == 0) {
            throw new IllegalArgumentException("command must be non-empty");
        }
        for (String commandToken : command) {
            if (commandToken != null) continue;
            throw new NullPointerException("invalid null token in command: " + Arrays.toString(command));
        }
        String[] helperCommand = this.getHelperCommand(prompt, icon);
        if (helperCommand == null) {
            throw new ElevationFailedException("Cannot retrieve command to execute");
        }
        if (command.length > 1 && this.mergeClientCommand()) {
            StringBuilder sb = new StringBuilder(command[0]);
            for (int i = 1; i < command.length; ++i) {
                sb.append(" ").append(command[i]);
            }
            command = new String[]{sb.toString()};
        }
        Object[] completeCommand = new String[helperCommand.length + command.length];
        System.arraycopy(helperCommand, 0, completeCommand, 0, helperCommand.length);
        System.arraycopy(command, 0, completeCommand, helperCommand.length, command.length);
        LOG.info("Will execute the following command: " + Arrays.toString(completeCommand));
        ProcessBuilder pb = new ProcessBuilder((String[])completeCommand);
        return pb;
    }

    @Override
    public int getPriority() {
        return 0;
    }

    protected abstract String[] getHelperCommand(String var1, String var2);

    protected boolean mergeClientCommand() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final File extractHelperResource(String name) throws IOException {
        File helperResource;
        if (name == null) {
            throw new NullPointerException("name cannot be null");
        }
        InputStream helperResourceStream = this.getClass().getResourceAsStream(name);
        if (helperResourceStream == null) {
            throw new MissingResourceException("No resource found with this name", this.getClass().getName(), name);
        }
        FileOutputStream exeOut = null;
        try {
            helperResource = File.createTempFile("tmp_", name);
            helperResource.deleteOnExit();
            exeOut = new FileOutputStream(helperResource);
            IOUtils.copy(helperResourceStream, exeOut);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(exeOut);
            IOUtils.closeQuietly(helperResourceStream);
            throw throwable;
        }
        IOUtils.closeQuietly(exeOut);
        IOUtils.closeQuietly(helperResourceStream);
        return helperResource;
    }
}

