/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pm.utils.config.model;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jetbrains.annotations.NotNull;

public final class DisplayModelLayouter {
    static final String DIR = "getax-pm-cd/src/main/resources/config/common/model/expert/sa";
    static final String FILE = "declaration_SA.xml";
    static final String X_Y = "y";
    static final Double OFFSET = -0.2;
    static final Long FROM_LINE = 193L;
    static final Long TO_LINE = 207L;
    static final Double FROM_X = 0.0;
    static final Double TO_X = 999.9;
    static final Pattern X_PATTERN = Pattern.compile("^(.*x=\")(\\d*\\.?\\d*)(\".*)$");
    static final Pattern Y_PATTERN = Pattern.compile("^(.*y=\")(\\d*\\.?\\d*)(\".*)$");
    static final String ANSI_RESET = "\u001b[0m";
    static final String ANSI_RED = "\u001b[31m";
    static final String ANSI_BLUE = "\u001b[34m";
    static final String ANSI_GREEN = "\u001b[32m";

    public static void main(String[] args) {
        int answer = JOptionPane.showConfirmDialog(null, "Willst du wirklich die Felder im DisplayModel verschieben?\nOffset y = " + OFFSET + " von Zeile " + FROM_LINE + " bis " + TO_LINE, "DisplayModel declaration_SA.xml", 2);
        if (answer != 0) {
            System.out.println("... (noch) Nichts ge\u00e4ndert :-)");
            return;
        }
        Path path = Paths.get(DIR, FILE);
        List<String> lines = DisplayModelLayouter.readFile(path);
        List<String> newLines = DisplayModelLayouter.changeLines(lines);
        DisplayModelLayouter.writeChangedFile(path, newLines);
    }

    private static @NonNull List<String> readFile(Path path) {
        ArrayList<String> lines = new ArrayList();
        try {
            lines = Files.readAllLines(path);
        }
        catch (IOException ioe) {
            System.out.print(ioe);
        }
        return lines;
    }

    private static void writeChangedFile(Path path, List<String> newLines) {
        try {
            Files.write(path, newLines, StandardOpenOption.CREATE);
        }
        catch (IOException ioe) {
            System.out.print(ioe);
        }
    }

    private static @NonNull List<String> changeLines(@NonNull List<String> lines) {
        ArrayList<String> newLines = new ArrayList<String>();
        int z = 0;
        for (String line : lines) {
            ++z;
            Matcher matcher = DisplayModelLayouter.getMatcher(line);
            double oldValue = 0.0;
            double newValue = 0.0;
            Object newLine = line;
            boolean isChanged = false;
            if (matcher.matches()) {
                boolean isInAreaToChange;
                oldValue = Double.valueOf(matcher.group(2));
                boolean bl = isInAreaToChange = (long)z >= FROM_LINE && (long)z <= TO_LINE && (X_Y.equals(X_Y) || oldValue >= FROM_X && oldValue <= TO_X);
                if (isInAreaToChange) {
                    newValue = oldValue + OFFSET;
                    newLine = matcher.group(1) + newValue + matcher.group(3);
                    isChanged = true;
                }
            }
            newLines.add((String)newLine);
            DisplayModelLayouter.sysoutLine(z, line, matcher, oldValue, newValue, isChanged);
        }
        return newLines;
    }

    private static void sysoutLine(int z, String line, Matcher matcher, double oldValue, double newValue, boolean isChanged) {
        if (isChanged) {
            System.out.println(String.format("%04d : ", z) + matcher.group(1) + ANSI_RED + oldValue + "\u001b[34m --> \u001b[32m" + newValue + ANSI_RESET + matcher.group(3));
        } else {
            System.out.println(String.format("%04d : ", z) + line);
        }
    }

    @NotNull
    private static Matcher getMatcher(String line) {
        Matcher matcher = "x".equals(X_Y) ? X_PATTERN.matcher(line) : Y_PATTERN.matcher(line);
        return matcher;
    }
}

