/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pm.transfer.dto.convert;

import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class NoContribuableConverter
extends AbstractConverter<String> {
    private static final long serialVersionUID = 3258413941062578742L;
    private final Pattern patternValidate = Pattern.compile("(\\d\\d\\d)(\\.?)(\\d\\d\\d)(\\.?)(\\d\\d\\d)(\\-?)([1-9])");
    private final Pattern patternRender = Pattern.compile("(\\d\\d\\d)(\\d\\d\\d)(\\d\\d\\d)([1-9])");
    private final Pattern patternValidate2 = Pattern.compile("(\\d\\d\\d)(\\.?)(\\d\\d\\d)(\\.?)(\\d\\d\\d)");
    private final Pattern patternRender2 = Pattern.compile("(\\d\\d\\d)(\\d\\d\\d)(\\d\\d\\d)");

    public NoContribuableConverter() {
        super(String.class);
    }

    @Nullable
    public String getObject(@Nullable String s, @Nullable OptionItemsDTO optionItems, @Nonnull AbstractConverter.ConverterContext ctx) throws AbstractConverter.ConvertException {
        boolean isDeclarationAF;
        if (s == null || s.length() <= 0) {
            return null;
        }
        Map dataModel = TaxmeController.getInstance().getTmoCdSession().getDataModel();
        ModelItemDTO selectionSA = (ModelItemDTO)dataModel.get("Selection.SA");
        boolean isDeclarationSA = selectionSA != null && selectionSA.getValue() != null && (Boolean)selectionSA.getValue() != false;
        boolean bl = isDeclarationAF = !isDeclarationSA;
        if (isDeclarationSA && !s.startsWith("060") && !s.startsWith("069") && !s.startsWith("070")) {
            throw new AbstractConverter.ConvertException("error.format.noContribuable.wrongStartSA");
        }
        if (isDeclarationAF && !s.startsWith("080") && !s.startsWith("081") && !s.startsWith("082")) {
            throw new AbstractConverter.ConvertException("error.format.noContribuable.wrongStartAF");
        }
        Matcher m = this.patternValidate.matcher(s);
        Matcher m2 = this.patternValidate2.matcher(s);
        if (!m.matches() && !m2.matches()) {
            throw new AbstractConverter.ConvertException("error.format.noContribuable");
        }
        return s;
    }

    @Nullable
    public String getRenderedValue(@Nullable Object userInput, boolean readonly, @Nullable OptionItemsDTO optionItems, @Nonnull AbstractConverter.ConverterContext ctx) {
        if (userInput == null) {
            return "";
        }
        String formattedInput = userInput.toString().replaceAll("\\.", "").replace("-", "");
        Matcher m = this.patternRender.matcher(formattedInput.toString());
        if (m.matches()) {
            return m.group(1) + "." + m.group(2) + "." + m.group(3) + "-" + m.group(4);
        }
        Matcher m2 = this.patternRender2.matcher(formattedInput.toString());
        if (m2.matches()) {
            return m2.group(1) + "." + m2.group(2) + "." + m2.group(3);
        }
        return formattedInput.toString();
    }

    @Nonnull
    public String getUserInputRegExpPattern() {
        return "[0-9]{1,3}(\\.?)[0-9]{0,3}(\\.?)[0-9]{0,3}(\\-?)[1-9]{0,1}";
    }
}

