/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pm.transfer.dto.convert;

import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CodeDeclarationConverter
extends AbstractConverter<String> {
    private static final long serialVersionUID = 3258413941062578742L;
    private static final Pattern CODE_PTN = Pattern.compile("(\\d\\d)\\-?(\\d\\d\\d)\\-?(\\d\\d\\d)");

    public CodeDeclarationConverter() {
        super(String.class);
    }

    @Nullable
    public String getObject(@Nullable String s, @Nullable OptionItemsDTO optionItems, @Nonnull AbstractConverter.ConverterContext ctx) throws AbstractConverter.ConvertException {
        if (s == null || s.length() <= 0) {
            return null;
        }
        String value = this.formatInput(s);
        if (value == null) {
            throw new AbstractConverter.ConvertException("error.format.codeDecla");
        }
        return value;
    }

    @Nullable
    public String getRenderedValue(@Nullable Object o, boolean readonly, @Nullable OptionItemsDTO optionItems, @Nonnull AbstractConverter.ConverterContext ctx) {
        if (o == null) {
            return "";
        }
        String input = o.toString();
        String renderedValue = this.formatInput(input);
        return renderedValue != null ? renderedValue : input;
    }

    private String formatInput(String input) {
        assert (input != null);
        Matcher m = CODE_PTN.matcher(input);
        if (m.matches()) {
            assert (m.groupCount() == 3);
            return m.group(1) + "-" + m.group(2) + "-" + m.group(3);
        }
        return null;
    }

    @Nonnull
    public String getUserInputRegExpPattern() {
        return "[0-9]{1,2}\\-?[0-9]{0,3}\\-?[0-9]{0,3}";
    }
}

