/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pm.transfer.dto.convert;

import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AhvNeuAltConverter
extends AbstractConverter<String> {
    private static final long serialVersionUID = -6841670933609606809L;
    private final Pattern patternValidateNeu = Pattern.compile("(\\d\\d\\d)(\\.?)(\\d\\d\\d\\d)(\\.?)(\\d\\d\\d\\d)(\\.?)(\\d\\d)");
    private final Pattern patternRenderNeu = Pattern.compile("(\\d\\d\\d)(\\d\\d\\d\\d)(\\d\\d\\d\\d)(\\d\\d)");

    public AhvNeuAltConverter() {
        super(String.class);
    }

    @Nullable
    public String getObject(@Nullable String s, @Nullable OptionItemsDTO optionItems, @Nonnull AbstractConverter.ConverterContext ctx) throws AbstractConverter.ConvertException {
        if (s == null || s.length() <= 0) {
            return null;
        }
        Matcher mNeu = this.patternValidateNeu.matcher(s);
        boolean neuMatch = mNeu.matches();
        if (!neuMatch) {
            throw new AbstractConverter.ConvertException("error.format.ahv");
        }
        if (neuMatch && !this.isChiffreNSSValid(s)) {
            throw new AbstractConverter.ConvertException("error.format.ahv");
        }
        return this.getRenderedValue(s, false, optionItems, null);
    }

    @Nullable
    public String getRenderedValue(@Nullable Object o, boolean readonly, @Nullable OptionItemsDTO optionItems, @Nonnull AbstractConverter.ConverterContext ctx) {
        if (o == null) {
            return "";
        }
        Matcher mNeu = this.patternValidateNeu.matcher(o.toString());
        if (!mNeu.matches()) {
            return o.toString();
        }
        Matcher m = this.patternRenderNeu.matcher(o.toString());
        if (m.matches()) {
            return m.group(1) + "." + m.group(2) + "." + m.group(3) + "." + m.group(4);
        }
        return o.toString();
    }

    public int getMaxLength() {
        return 16;
    }

    @Nonnull
    public String getUserInputRegExpPattern() {
        return super.getUserInputRegExpPattern();
    }

    private boolean isChiffreNSSValid(String sAvs) {
        int checkDigit = 0;
        int[] chiffres = this.getDigitsNew(sAvs);
        int length = chiffres.length;
        for (int i = 0; i < length - 1; ++i) {
            if (i % 2 == 0) {
                checkDigit += chiffres[i];
                continue;
            }
            checkDigit += 3 * chiffres[i];
        }
        checkDigit %= 10;
        return (checkDigit = (10 - checkDigit) % 10) == chiffres[length - 1];
    }

    private int[] getDigitsNew(String sAvs) {
        int avsLength = sAvs.length();
        int[] chiffres = new int[13];
        int j = 0;
        for (int i = 0; i < sAvs.length() - 1; ++i) {
            String tmpString = sAvs.substring(i, i + 1);
            if (".".contains(tmpString)) continue;
            chiffres[j] = Integer.parseInt(sAvs.substring(i, i + 1));
            ++j;
        }
        chiffres[12] = Integer.parseInt(sAvs.substring(avsLength - 1));
        return chiffres;
    }
}

