/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pm.presentation.cd.util;

import java.util.Arrays;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;

public class CodeDeclarationIdentificationCodeCalculator {
    private final String textAddition = "";
    private final String checksumFormat = "AAA";
    private final String steuerjahr;
    private static final List<Character> _LIST_CHAR = Arrays.asList(Character.valueOf('A'), Character.valueOf('B'), Character.valueOf('C'), Character.valueOf('D'), Character.valueOf('E'), Character.valueOf('F'), Character.valueOf('G'), Character.valueOf('H'), Character.valueOf('J'), Character.valueOf('K'), Character.valueOf('L'), Character.valueOf('M'), Character.valueOf('N'), Character.valueOf('P'), Character.valueOf('Q'), Character.valueOf('R'), Character.valueOf('S'), Character.valueOf('T'), Character.valueOf('U'), Character.valueOf('V'), Character.valueOf('W'), Character.valueOf('X'), Character.valueOf('Y'), Character.valueOf('Z'));
    private static final List<Character> _LIST_NUM = Arrays.asList(Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8'), Character.valueOf('9'));

    public CodeDeclarationIdentificationCodeCalculator(String steuerjahr) {
        this.steuerjahr = steuerjahr;
    }

    public String getCodeDeclarationWithControlCode(@NonNull String noContribuable, @NonNull String codeDecla) {
        return CodeDeclarationIdentificationCodeCalculator.getCodeDeclarationWithControlCode(noContribuable, codeDecla, this.steuerjahr, "", "AAA");
    }

    public String getCodeDeclarationControlCode(@NonNull String noContribuable, @NonNull String codeDecla) {
        return CodeDeclarationIdentificationCodeCalculator.codageIdentifiant(Math.abs((this.steuerjahr + noContribuable.replaceAll("[^\\d]", "").replace("-", "") + codeDecla.replace("-", "")).hashCode()), "AAA");
    }

    private static String getCodeDeclarationWithControlCode(@NonNull String noContrib, @NonNull String codeDecla, String year, String textAddition, String expectedFormat) {
        noContrib = noContrib.replace(".", "").replace("-", "");
        return codeDecla + "-" + CodeDeclarationIdentificationCodeCalculator.codageIdentifiant(Math.abs((year + noContrib + codeDecla.replace("-", "") + textAddition).hashCode()), expectedFormat);
    }

    public static String codageIdentifiant(long identifiant, @NonNull String pFormatCodage) {
        char[] buff = pFormatCodage.toCharArray();
        int i = pFormatCodage.length() - 1;
        int modulo = 0;
        while (identifiant != 0L) {
            boolean isNum = pFormatCodage.charAt(i) == '0';
            modulo = isNum ? 10 : 24;
            int index = Math.abs((int)(identifiant % (long)modulo));
            buff[i] = (isNum ? _LIST_NUM.get(index) : _LIST_CHAR.get(index)).charValue();
            identifiant /= (long)modulo;
            if (i == 0) break;
            --i;
        }
        StringBuffer s = new StringBuffer();
        s.append(buff);
        return s.toString();
    }
}

