/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pm.presentation.cd.upload;

import ch.dvbern.tax.common.integration.conf.ApplicationConfig;
import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.ge.pm.presentation.cd.justificatifs.FSDocumentStore;
import ch.dvbern.tax.ge.pm.presentation.cd.justificatifs.UploadedDocument;
import ch.dvbern.tax.ge.pm.presentation.cd.upload.CountingDataSource;
import ch.dvbern.tax.ge.pm.presentation.cd.upload.CryptoSession;
import ch.dvbern.tax.ge.pm.presentation.cd.upload.UploadRequest;
import ch.dvbern.tax.ge.pm.presentation.cd.upload.UploadResultDTO;
import ch.ge.afc.ael.fo.teledeclaration.pm.EnumTypeOperationTeleversement;
import ch.ge.afc.ael.fo.teledeclaration.pm.ITeleDeclarationWS;
import ch.ge.afc.ael.fo.teledeclaration.pm.ParametreTeleversement;
import ch.ge.afc.ael.fo.teledeclaration.pm.PiecesJointes;
import ch.ge.afc.ael.fo.teledeclaration.pm.ResultatTeleversement;
import ch.ge.afc.ael.fo.teledeclaration.pm.TeleDeclarationService;
import java.io.IOException;
import java.lang.invoke.StringConcatFactory;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.activation.DataHandler;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.crypto.Cipher;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.MTOMFeature;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadWSClient {
    private static final Logger LOG = LoggerFactory.getLogger(UploadWSClient.class);
    private static final String WSDL_URL_CONFIG_KEY = "televersement.web.service.url";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public UploadResultDTO upload(@Nonnull IProgressMonitor monitor, @Nonnull UploadRequest request, @Nullable byte[] signature, @Nonnull byte[] barcode, @Nullable byte[] pdf, FSDocumentStore documentStore) throws IOException, InterruptedException, GeneralSecurityException {
        Objects.requireNonNull(monitor, "Progress monitor cannot be null.");
        Objects.requireNonNull(request, "Upload request cannot be null.");
        Objects.requireNonNull(barcode, "Barcode cannot be null.");
        Objects.requireNonNull(pdf, "PDF file cannot be null.");
        Objects.requireNonNull(documentStore, "Document store cannot be null.");
        ArrayList<CountingDataSource> dataSources = new ArrayList<CountingDataSource>();
        FSDocumentStore.Index index = documentStore.getIndex();
        int totalWork = barcode.length + pdf.length + (int)index.getTotalSize();
        monitor.beginTask(Messages.translate((String)"label.upload.wait", (Object[])new Object[0]), totalWork);
        ITeleDeclarationWS ws = this.getBinding();
        CryptoSession cryptoSession = request.getCryptoSession();
        ParametreTeleversement params = new ParametreTeleversement();
        params.setPeriode(ApplicationConfig.getInstance().getJahr());
        params.setCleSession(cryptoSession.getWrappedKey());
        CountingDataSource.ByteArrayDataSource barcodeDS = new CountingDataSource.ByteArrayDataSource(cryptoSession, "barcode.xml", barcode);
        dataSources.add(barcodeDS);
        params.setDeclarationXml(new DataHandler(barcodeDS));
        CountingDataSource.ByteArrayDataSource pdfDS = new CountingDataSource.ByteArrayDataSource(cryptoSession, "declaration.pdf", pdf);
        dataSources.add(pdfDS);
        params.setDeclarationPdf(new DataHandler(pdfDS));
        params.setOperation(signature != null ? EnumTypeOperationTeleversement.DEPOT : EnumTypeOperationTeleversement.SOUMISSION);
        Cipher cipher = null;
        if (signature != null) {
            cipher = cryptoSession.getCipher();
            cryptoSession.initCipher(cipher, 1);
            byte[] cipheredSignature = cipher.doFinal(signature);
            params.setSignature(cipheredSignature);
        }
        List<PiecesJointes> attachments = params.getPiecesJointes();
        List<UploadedDocument> docs = index.getDocs();
        if (!docs.isEmpty() && cipher == null) {
            cipher = cryptoSession.getCipher();
        }
        int id = 0;
        for (UploadedDocument doc : docs) {
            PiecesJointes attachment = new PiecesJointes();
            attachment.setId(id++);
            cryptoSession.initCipher(cipher, 1);
            attachment.setDescription(cipher.doFinal(doc.getDescription().getBytes(StandardCharsets.UTF_8)));
            cryptoSession.initCipher(cipher, 1);
            attachment.setFilename(cipher.doFinal(doc.getOrigFilename().getBytes(StandardCharsets.UTF_8)));
            CountingDataSource.UserDocumentDataSource dataSource = new CountingDataSource.UserDocumentDataSource(cryptoSession, doc);
            attachment.setContenu(new DataHandler(dataSource));
            dataSources.add(dataSource);
            attachment.setType(doc.getCategory().getUploadKey());
            attachments.add(attachment);
        }
        ExecutorService executor = Executors.newSingleThreadExecutor();
        int totalWorkPrevDone = 0;
        int counter = 0;
        ResultatTeleversement result = null;
        try {
            int totalWorkDone = 0;
            Future<ResultatTeleversement> futureResponse = executor.submit(() -> ws.televerserDeclarationV3(params));
            do {
                try {
                    this.checkCancellation(monitor);
                    if (dataSources.size() > counter) {
                        totalWorkDone += ((CountingDataSource)dataSources.get(counter)).getReadCounter();
                        ++counter;
                    }
                    monitor.worked(totalWorkDone - totalWorkPrevDone);
                    monitor.subTask(Messages.translate((String)"release.progress.percent", (Object[])new Object[]{Float.valueOf((float)totalWorkDone / (float)totalWork)}));
                    totalWorkPrevDone = totalWorkDone;
                    result = futureResponse.get(1L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    futureResponse.cancel(true);
                    throw e;
                }
                catch (ExecutionException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof Error) {
                        throw (Error)cause;
                    }
                    throw new IOException("Call to web-service failed", e);
                }
                catch (TimeoutException timeoutException) {
                    // empty catch block
                }
            } while (!futureResponse.isDone());
        }
        finally {
            executor.shutdownNow();
        }
        assert (result != null) : "Call is done without error but no result available.";
        byte[] resultContent = result.getResultat();
        LOG.info((String)("Web service call completed. Outcome: [" + result.getCode() + "]  Info: [" + result.getInfo() + "]  Result: {" + resultContent != null ? resultContent.toString() : StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"null} bytes."})));
        return UploadResultDTO.process(result, docs);
    }

    private ITeleDeclarationWS getBinding() {
        URL wsdlUrl;
        String wsdlUrlStr = TaxmeConfig.getString((String)WSDL_URL_CONFIG_KEY);
        try {
            wsdlUrl = new URL(wsdlUrlStr);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Cannot parse WSDL URL config entry: televersement.web.service.url=" + wsdlUrlStr);
        }
        LOG.debug("Using wsdl: {}", (Object)wsdlUrl);
        TeleDeclarationService webService = new TeleDeclarationService(wsdlUrl);
        ITeleDeclarationWS port = webService.getTeleDeclarationWSPort(new WebServiceFeature[]{new MTOMFeature(true, 0)});
        BindingProvider provider = (BindingProvider)port;
        try {
            Map requestContext = provider.getRequestContext();
            URI portURI = new URI((String)requestContext.get("javax.xml.ws.service.endpoint.address"));
            URI fixedURI = new URI(wsdlUrl.getProtocol(), portURI.getUserInfo(), wsdlUrl.getHost(), wsdlUrl.getPort(), portURI.getPath(), portURI.getQuery(), portURI.getFragment());
            requestContext.put("javax.xml.ws.service.endpoint.address", fixedURI.toString());
            LOG.info("Changed port binding URI from {} to {}", (Object)portURI, (Object)fixedURI);
        }
        catch (URISyntaxException e) {
            LOG.warn("Failed to parse port binding URI, WS call may fail", (Throwable)e);
        }
        return port;
    }

    private void checkCancellation(IProgressMonitor monitor) throws InterruptedException {
        assert (monitor != null);
        if (monitor.isCanceled()) {
            throw new InterruptedException("Cancelled during upload.");
        }
    }
}

