/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pm.presentation.cd.upload;

import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.action.menu.HelpMainhelpAction;
import ch.dvbern.tax.common.presentation.cd.util.GuiUtil;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;

class UploadErrorDialog
extends Dialog {
    private final String userErrorMessage;
    private final boolean isContribuableError;

    public UploadErrorDialog(@Nullable Shell shell, @Nonnull String userErrorMessage, @Nonnull boolean isContribuableError) {
        super(shell);
        Objects.requireNonNull(userErrorMessage, "User error message cannot be null.");
        this.userErrorMessage = userErrorMessage;
        this.isContribuableError = isContribuableError;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.translate((String)"release.error.title", (Object[])new Object[0]));
    }

    protected Control createDialogArea(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        panel.setLayout((Layout)layout);
        panel.setLayoutData((Object)new GridData());
        GridDataFactory gdInfo = GridDataFactory.swtDefaults().hint(530, -1);
        Label labelError2 = new Label(panel, 64);
        labelError2.setLayoutData((Object)gdInfo.create());
        labelError2.setText(Messages.translate((String)"release.error.lbl1", (Object[])new Object[0]));
        labelError2.setFont(GuiUtil.getFontRegistry().getBold("font.normal"));
        Label labelErrorEnum = new Label(panel, 64);
        labelErrorEnum.setLayoutData((Object)gdInfo.create());
        labelErrorEnum.setText(this.userErrorMessage);
        Label labelEmpty = new Label(panel, 64);
        labelEmpty.setLayoutData((Object)gdInfo.create());
        labelEmpty.setText(Messages.translate((String)"label.empty", (Object[])new Object[]{labelEmpty}));
        Link linkError3 = new Link(panel, 64);
        linkError3.setLayoutData((Object)gdInfo.create());
        String msgLink = this.isContribuableError ? "release.error.lbl2.noContribError" : "release.error.lbl2";
        linkError3.setText(Messages.translate((String)msgLink, (Object[])new Object[]{linkError3}));
        linkError3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                HelpMainhelpAction help = new HelpMainhelpAction(UploadErrorDialog.this.getShell(), event.text);
                help.run();
            }
        });
        return panel;
    }
}

