/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pm.presentation.cd.upload;

import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.action.menu.HelpMainhelpAction;
import ch.dvbern.tax.common.presentation.cd.util.DialogUtil;
import ch.dvbern.tax.ge.pm.envoi.ReleaseMode;
import ch.dvbern.tax.ge.pm.presentation.cd.GeDvbTaxCdSession;
import ch.dvbern.tax.ge.pm.presentation.cd.util.GeResources;
import javax.annotation.Nullable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IconAndMessageDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.RowDataFactory;
import org.eclipse.jface.layout.RowLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;

public class ReleaseDialog
extends Dialog {
    public static final String CODE_PRINT_XML_ENABLED = "888";
    private final boolean withAttachments;
    private final boolean readyForRelease;
    private final boolean codeDeclaAvailable;
    private final boolean codeDeclaCorrect;
    private ReleaseMode releaseMode;
    private GeDvbTaxCdSession session;

    public ReleaseDialog(Shell parentShell, boolean withAttachments, boolean readyForRelease, boolean codeDeclaAvailable, boolean codeDeclaCorrect) {
        super(parentShell);
        this.withAttachments = withAttachments;
        this.readyForRelease = readyForRelease;
        this.codeDeclaAvailable = codeDeclaAvailable;
        this.codeDeclaCorrect = codeDeclaCorrect;
        this.session = (GeDvbTaxCdSession)TaxmeController.getInstance().getTmoCdSession();
    }

    @Nullable
    public ReleaseMode getReleaseMode() {
        return this.releaseMode;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.translate((String)"release.dialog.title", (Object[])new Object[0]));
    }

    protected Control createDialogArea(Composite parent) {
        int upperPanelsWidth = 370;
        int upperPanelsTextWidth = 355;
        Composite mainPanel = new Composite(parent, 0);
        mainPanel.setLayout((Layout)new GridLayout(1, false));
        Label introLbl = new Label(mainPanel, 0);
        introLbl.setText(Messages.translate((String)"release.dialog.intro", (Object[])new Object[0]));
        introLbl.setLayoutData((Object)GridDataFactory.swtDefaults().span(2, 1).create());
        SelectionListener openHelpLst = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }

            public void widgetSelected(SelectionEvent event) {
                HelpMainhelpAction help = new HelpMainhelpAction(ReleaseDialog.this.getShell(), event.text);
                help.run();
            }
        };
        Composite title1Grid = new Composite(mainPanel, 0);
        title1Grid.setLayout((Layout)new GridLayout(2, false));
        Label depotLblTitle = new Label(title1Grid, 0x1000040);
        depotLblTitle.setText(Messages.translate((String)"release.dialog.depot.title.part", (Object[])new Object[0]));
        depotLblTitle.setFont(GeResources.Font.DIALOG_TITLE.get());
        depotLblTitle.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        depotLblTitle.setBackground(this.getShell().getBackground());
        Composite depotPanel = new Composite(mainPanel, 0);
        depotPanel.setLayout((Layout)new GridLayout(2, false));
        Button depotBtn = new Button(depotPanel, 0x1000000);
        depotBtn.setText(Messages.translate((String)"release.dialog.depot.btn", (Object[])new Object[0]));
        depotBtn.setAlignment(0x1000000);
        depotBtn.setFont(GeResources.Font.SMALL.get());
        GridData depotBtnGd = new GridData(0x1000000, 0x1000000, false, false, 1, 5);
        depotBtnGd.widthHint = 100;
        depotBtnGd.heightHint = 50;
        depotBtn.setLayoutData((Object)depotBtnGd);
        depotBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ReleaseDialog.this.setReleaseMode(ReleaseMode.DEPOT);
            }
        });
        GridDataFactory lblGdFty = GridDataFactory.swtDefaults().align(0x1000000, 128).hint(355, -1).grab(true, false);
        Label depotLbl1 = new Label(depotPanel, 0);
        depotLbl1.setText("\u2022 " + Messages.translate((String)"release.dialog.depot.label.1", (Object[])new Object[0]));
        Label depotLbl2 = new Label(depotPanel, 0);
        depotLbl2.setText("\u2022 " + Messages.translate((String)"release.dialog.depot.label.2", (Object[])new Object[0]));
        Label depotLbl3 = new Label(depotPanel, 0);
        depotLbl3.setText("\u2022 " + Messages.translate((String)"release.dialog.depot.label.3", (Object[])new Object[0]));
        Label depotLbl4 = new Label(depotPanel, 0);
        depotLbl4.setText("\u2022 " + Messages.translate((String)"release.dialog.depot.label.4", (Object[])new Object[0]));
        Label depotLbl5 = new Label(depotPanel, 0);
        depotLbl5.setText("\u2022 " + Messages.translate((String)"release.dialog.depot.label.5", (Object[])new Object[0]));
        Link depotHelpLnk = new Link(depotPanel, 0);
        depotHelpLnk.setText(Messages.translate((String)"release.dialog.depot.help", (Object[])new Object[0]));
        depotHelpLnk.addSelectionListener(openHelpLst);
        depotHelpLnk.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        Composite title2Grid = new Composite(mainPanel, 0);
        title2Grid.setLayout((Layout)new GridLayout(2, false));
        Label tlvTitleLbl = new Label(title2Grid, 0x1000040);
        tlvTitleLbl.setFont(GeResources.Font.DIALOG_TITLE.get());
        tlvTitleLbl.setText(Messages.translate((String)"release.dialog.tlv.title", (Object[])new Object[0]));
        tlvTitleLbl.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        Composite tlvPanel = new Composite(mainPanel, 0);
        tlvPanel.setLayout((Layout)new GridLayout(2, false));
        Button tlvBtn = new Button(tlvPanel, 8);
        tlvBtn.setText(Messages.translate((String)"release.dialog.tlv.btn", (Object[])new Object[0]));
        tlvBtn.setAlignment(0x1000000);
        GridData tlvBtnGd = new GridData(0x1000000, 0x1000000, false, false, 1, 4);
        tlvBtnGd.widthHint = 100;
        tlvBtnGd.heightHint = 50;
        tlvBtn.setLayoutData((Object)tlvBtnGd);
        tlvBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ReleaseDialog.this.setReleaseMode(ReleaseMode.SOUMISSION);
            }
        });
        Label tlvLbl = new Label(tlvPanel, 0);
        tlvLbl.setText("\u2022 " + Messages.translate((String)"release.dialog.tlv.label.1", (Object[])new Object[0]));
        Label tlvLbl2 = new Label(tlvPanel, 0);
        tlvLbl2.setText("\u2022 " + Messages.translate((String)"release.dialog.tlv.label.2", (Object[])new Object[0]));
        Label tlvLbl3 = new Label(tlvPanel, 0);
        tlvLbl3.setText("\u2022 " + Messages.translate((String)"release.dialog.tlv.label.3", (Object[])new Object[0]));
        Label tlvLbl4 = new Label(tlvPanel, 0);
        tlvLbl4.setText("\u2022 " + Messages.translate((String)"release.dialog.tlv.label.4", (Object[])new Object[0]));
        Link tlvHelpLnk = new Link(tlvPanel, 0);
        tlvHelpLnk.setText(Messages.translate((String)"release.dialog.tlv.help", (Object[])new Object[0]));
        tlvHelpLnk.addSelectionListener(openHelpLst);
        tlvHelpLnk.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        if (TaxmeConfig.isDebugEnabled() && TaxmeConfig.getString((String)"xml.generation.button") != null && TaxmeConfig.getString((String)"xml.generation.button").equalsIgnoreCase(CODE_PRINT_XML_ENABLED)) {
            Composite printPanel = new Composite(mainPanel, 2048);
            GridData gridData = new GridData(4, 4, true, false);
            printPanel.setLayoutData((Object)gridData);
            printPanel.setLayout((Layout)new GridLayout(1, false));
            Button printBtn = new Button(printPanel, 8);
            printBtn.setText(Messages.translate((String)"release.dialog.print.btn.xml", (Object[])new Object[0]));
            printBtn.setAlignment(0x1000000);
            GridData printBtnGd = new GridData(0x1000000, 0x1000000, true, false, 1, 3);
            printBtnGd.widthHint = 160;
            printBtnGd.heightHint = 30;
            printBtn.setLayoutData((Object)printBtnGd);
            printBtn.setFont(GeResources.Font.DIALOG_TITLE.get());
            printBtn.addSelectionListener((SelectionListener)new ReleaseButtonListener(ReleaseMode.PRINT){

                @Override
                public void widgetSelected(SelectionEvent selectionEvent) {
                    ReleaseDialog.this.setReleaseMode(ReleaseMode.PRINT);
                }
            });
        }
        int lblHeight = Math.max(depotPanel.computeSize((int)-1, (int)-1).y, tlvPanel.computeSize((int)-1, (int)-1).y);
        depotPanel.setLayoutData((Object)GridDataFactory.swtDefaults().hint(-1, lblHeight).create());
        tlvPanel.setLayoutData((Object)GridDataFactory.swtDefaults().hint(-1, lblHeight).create());
        mainPanel.layout();
        return mainPanel;
    }

    private void addBullet(Composite panel) {
        Label bulletLbl = new Label(panel, 0);
        bulletLbl.setText("\u2022 ");
        bulletLbl.setLayoutData((Object)GridDataFactory.swtDefaults().align(0x1000000, 128).create());
    }

    private void setReleaseMode(ReleaseMode releaseMode) {
        assert (releaseMode != null);
        if (!this.readyForRelease) {
            DialogUtil.showWarningDialog((Shell)this.getShell(), (String)"release.dialog.error.state", (Object[])new Object[0]);
            return;
        }
        if (this.codeDeclaAvailable && !this.codeDeclaCorrect) {
            DialogUtil.showWarningDialog((Shell)this.getShell(), (String)"release.dialog.error.codeDecla", (Object[])new Object[0]);
            return;
        }
        if (this.session.isMonnaieFonctionelle()) {
            DialogUtil.showWarningDialog((Shell)this.getShell(), (String)"release.dialog.warning.monnaie", (Object[])new Object[0]);
        }
        switch (releaseMode) {
            case DEPOT: 
            case SOUMISSION: {
                if (this.codeDeclaAvailable) break;
                MessageDialog dlg = new MessageDialog(this.getShell(), Messages.translate((String)"title.warning", (Object[])new Object[0]), null, Messages.translate((String)"release.dialog.error.codeDecla.1", (Object[])new Object[0]), 4, new String[]{Messages.translate((String)"label.button.ok", (Object[])new Object[0])}, 0){

                    protected Control createCustomArea(Composite parent) {
                        Composite panel = new Composite(parent, 0);
                        panel.setLayout((Layout)new GridLayout(2, false));
                        Label lbl = new Label(panel, 0);
                        lbl.setText(Messages.translate((String)"release.dialog.error.codeDecla.2", (Object[])new Object[0]));
                        lbl.setLayoutData((Object)GridDataFactory.swtDefaults().span(2, 1).create());
                        ReleaseDialog.this.addBullet(panel);
                        lbl = new Label(panel, 0);
                        lbl.setText(Messages.translate((String)"release.dialog.error.codeDecla.2a", (Object[])new Object[0]));
                        ReleaseDialog.this.addBullet(panel);
                        lbl = new Label(panel, 0);
                        lbl.setText(Messages.translate((String)"release.dialog.error.codeDecla.2b", (Object[])new Object[0]));
                        return panel;
                    }
                };
                dlg.open();
                releaseMode = null;
                break;
            }
            case PRINT: {
                if (!this.withAttachments) break;
                PrintWithAttachmentsDialog printWithAttDialog = new PrintWithAttachmentsDialog(this.getShell());
                printWithAttDialog.open();
                releaseMode = printWithAttDialog.releaseMode;
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown enum member: " + releaseMode));
            }
        }
        this.releaseMode = releaseMode;
        if (releaseMode != null) {
            this.okPressed();
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, Messages.configurableTranslate((String)"label.button.cancel", (Object[])new Object[0]), false).setFocus();
    }

    private class PrintWithAttachmentsDialog
    extends IconAndMessageDialog {
        ReleaseMode releaseMode;

        PrintWithAttachmentsDialog(Shell parentShell) {
            super(parentShell);
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText(Messages.translate((String)"title.warning", (Object[])new Object[0]));
        }

        protected Control createDialogArea(Composite parent) {
            this.createMessageArea(parent);
            Composite mainPanel = new Composite(parent, 0);
            mainPanel.setLayout((Layout)RowLayoutFactory.swtDefaults().spacing(10).type(512).create());
            Label lbl1 = new Label(mainPanel, 64);
            lbl1.setText(Messages.translate((String)"release.dialog.print.withAttachments.1", (Object[])new Object[0]));
            Label lbl2 = new Label(mainPanel, 64);
            lbl2.setText(Messages.translate((String)"release.dialog.print.withAttachments.2", (Object[])new Object[0]));
            Composite btnPanel = new Composite(mainPanel, 0);
            btnPanel.setLayout((Layout)new GridLayout(4, false));
            Label printAttachLbl1 = new Label(btnPanel, 0);
            printAttachLbl1.setText(Messages.translate((String)"release.dialog.print.withAttachments.choice.1", (Object[])new Object[0]));
            Button tlvBtn = new Button(btnPanel, 8);
            tlvBtn.setText(Messages.translate((String)"release.dialog.tlv.btn", (Object[])new Object[0]));
            tlvBtn.setAlignment(0x1000000);
            tlvBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    PrintWithAttachmentsDialog.this.releaseMode = ReleaseMode.SOUMISSION;
                    PrintWithAttachmentsDialog.this.okPressed();
                }
            });
            tlvBtn.setLayoutData((Object)GridDataFactory.swtDefaults().align(0x1000000, 0x1000000).create());
            Label printAttachLbl2 = new Label(btnPanel, 0);
            printAttachLbl2.setText(Messages.translate((String)"release.dialog.print.withAttachments.choice.2", (Object[])new Object[0]));
            Button printBtn = new Button(btnPanel, 8);
            printBtn.setText(Messages.translate((String)"release.dialog.print.btn", (Object[])new Object[0]));
            printBtn.setAlignment(0x1000000);
            printBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    PrintWithAttachmentsDialog.this.releaseMode = ReleaseMode.PRINT;
                    PrintWithAttachmentsDialog.this.okPressed();
                }
            });
            RowDataFactory lblGdFty = RowDataFactory.swtDefaults().hint(btnPanel.computeSize((int)-1, (int)-1).x, -1);
            lblGdFty.applyTo((Control)lbl1);
            lblGdFty.applyTo((Control)lbl2);
            return mainPanel;
        }

        protected void createButtonsForButtonBar(Composite parent) {
        }

        protected Image getImage() {
            return Display.getCurrent().getSystemImage(8);
        }
    }

    private class ReleaseButtonListener
    extends SelectionAdapter {
        final ReleaseMode releaseMode;

        ReleaseButtonListener(ReleaseMode releaseMode) {
            assert (releaseMode != null);
            this.releaseMode = releaseMode;
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            ReleaseDialog.this.setReleaseMode(this.releaseMode);
        }
    }
}

