/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pm.presentation.cd.upload;

import ch.dvbern.tax.ge.pm.presentation.cd.Environment;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

public final class CryptoSession {
    public static final String SESSION_KEY_ALG = "AES";
    public static final String ENC_TRANSFORMATION = "AES/ECB/PKCS5Padding";
    public static final String PUBLIC_KEY_ALG = "RSA";
    public static final int SESSION_KEY_SIZE = 128;
    private static final Lock LOCK = new Lock();
    private final SecretKey sessionKey;
    private final byte[] wrappedKey;

    private CryptoSession(SecretKey sessionKey, byte[] wrappedKey) {
        assert (sessionKey != null && wrappedKey != null);
        this.sessionKey = sessionKey;
        this.wrappedKey = wrappedKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CryptoSession newInstance() throws GeneralSecurityException {
        Lock lock = LOCK;
        synchronized (lock) {
            Cipher masterCipher;
            KeyGenerator keyGenerator;
            PublicKey publicKey;
            if (!CryptoSession.LOCK.initDone) {
                publicKey = CryptoSession.loadPublicKey();
                keyGenerator = KeyGenerator.getInstance(SESSION_KEY_ALG);
                keyGenerator.init(128);
                masterCipher = Cipher.getInstance(PUBLIC_KEY_ALG);
                CryptoSession.LOCK.publicKey = publicKey;
                CryptoSession.LOCK.keyGenerator = keyGenerator;
                CryptoSession.LOCK.masterCipher = masterCipher;
                CryptoSession.LOCK.initDone = true;
            } else {
                publicKey = CryptoSession.LOCK.publicKey;
                keyGenerator = CryptoSession.LOCK.keyGenerator;
                masterCipher = CryptoSession.LOCK.masterCipher;
            }
            SecretKey sessionKey = keyGenerator.generateKey();
            masterCipher.init(3, publicKey);
            byte[] wrappedKey = masterCipher.wrap(sessionKey);
            return new CryptoSession(sessionKey, wrappedKey);
        }
    }

    public Cipher getCipher() throws GeneralSecurityException {
        return Cipher.getInstance(ENC_TRANSFORMATION);
    }

    public void initCipher(Cipher cipher, int opmode) throws GeneralSecurityException {
        if (cipher == null) {
            throw new NullPointerException("Cipher object cannot be null");
        }
        cipher.init(opmode, this.sessionKey);
    }

    public byte[] getWrappedKey() {
        return Arrays.copyOf(this.wrappedKey, this.wrappedKey.length);
    }

    private static PublicKey loadPublicKey() throws GeneralSecurityException {
        byte[] rawPk;
        InputStream keyStream = Environment.getUploadPublicKeyStream();
        if (keyStream == null) {
            throw new UnrecoverableKeyException("Cannot locate public key file");
        }
        try {
            rawPk = IOUtils.toByteArray((InputStream)keyStream);
        }
        catch (IOException e) {
            throw new UnrecoverableKeyException("Failed to load public key file:\n" + ExceptionUtils.getStackTrace((Throwable)e));
        }
        X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(rawPk);
        KeyFactory keyFactory = KeyFactory.getInstance(PUBLIC_KEY_ALG);
        return keyFactory.generatePublic(pubKeySpec);
    }

    private static class Lock {
        PublicKey publicKey;
        KeyGenerator keyGenerator;
        Cipher masterCipher;
        boolean initDone = false;

        private Lock() {
        }
    }
}

