/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pm.presentation.cd.upload;

import ch.dvbern.tax.ge.pm.presentation.cd.justificatifs.UploadedDocument;
import ch.dvbern.tax.ge.pm.presentation.cd.upload.CryptoSession;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.GeneralSecurityException;
import java.util.Objects;
import javax.activation.DataSource;
import javax.annotation.Nonnull;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import org.apache.commons.io.input.ProxyInputStream;

abstract class CountingDataSource
implements DataSource {
    private final CryptoSession cryptoSession;
    private volatile int readCounter = 0;

    CountingDataSource(@Nonnull CryptoSession cryptoSession) {
        Objects.requireNonNull(cryptoSession, "Crypto session cannot be null.");
        this.cryptoSession = cryptoSession;
    }

    @Override
    public String getContentType() {
        return "application/octet-stream";
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        throw new IOException("This data source is read-only.");
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.readCounter = 0;
        try {
            Cipher cipher = this.cryptoSession.getCipher();
            this.cryptoSession.initCipher(cipher, 1);
            return new CipherInputStream((InputStream)new ProxyInputStream(this.createStream()){

                protected void afterRead(int n) throws IOException {
                    CountingDataSource.this.readCounter += n;
                }
            }, cipher);
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e);
        }
    }

    protected abstract InputStream createStream() throws IOException;

    public int getReadCounter() {
        return this.readCounter;
    }

    static class UserDocumentDataSource
    extends CountingDataSource {
        private final UploadedDocument document;

        UserDocumentDataSource(CryptoSession cryptoSession, UploadedDocument document) {
            super(cryptoSession);
            Objects.requireNonNull(document, "Document cannot be null.");
            this.document = document;
        }

        @Override
        public String getName() {
            return this.document.getOrigFilename();
        }

        @Override
        protected InputStream createStream() throws IOException {
            return new BufferedInputStream(Files.newInputStream(this.document.getPath(), new OpenOption[0]));
        }
    }

    static class ByteArrayDataSource
    extends CountingDataSource {
        private final String name;
        private final byte[] data;

        ByteArrayDataSource(CryptoSession cryptoSession, String name, byte[] data) {
            super(cryptoSession);
            Objects.requireNonNull(name, "Data source name cannot be null.");
            Objects.requireNonNull(data, "Data array cannot be null.");
            this.name = name;
            this.data = data;
        }

        @Override
        protected InputStream createStream() throws IOException {
            return new ByteArrayInputStream(this.data);
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

