/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pm.presentation.cd.justificatifs;

import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.action.menu.HelpMainhelpAction;
import ch.dvbern.tax.common.presentation.cd.util.DialogUtil;
import ch.dvbern.tax.common.presentation.cd.util.LaunchUtil;
import ch.dvbern.tax.common.presentation.cd.util.PrintUtilCD;
import ch.dvbern.tax.common.presentation.common.print.PrintRequest;
import ch.dvbern.tax.ge.pm.envoi.ReleaseMode;
import ch.dvbern.tax.ge.pm.justificatifs.RequiredDocument;
import ch.dvbern.tax.ge.pm.justificatifs.RequiredDocumentsByCategory;
import ch.dvbern.tax.ge.pm.justificatifs.UploadedDocumentType;
import ch.dvbern.tax.ge.pm.presentation.cd.justificatifs.DocAlreadyStoredException;
import ch.dvbern.tax.ge.pm.presentation.cd.justificatifs.DocSizeLimitExceededException;
import ch.dvbern.tax.ge.pm.presentation.cd.justificatifs.FSDocumentStore;
import ch.dvbern.tax.ge.pm.presentation.cd.justificatifs.StoreSizeLimitExceededException;
import ch.dvbern.tax.ge.pm.presentation.cd.justificatifs.UnsupportedDocFormatException;
import ch.dvbern.tax.ge.pm.presentation.cd.justificatifs.UploadedDocument;
import ch.dvbern.tax.ge.pm.presentation.cd.util.GeResources;
import ch.dvbern.tax.ge.pm.utils.GeConstants;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserDocumentsDialog
extends Dialog {
    private static final Logger LOG = LoggerFactory.getLogger(UserDocumentsDialog.class);
    private static final int DESCRIPTION_MAX_LENGTH = 50;
    private final FSDocumentStore documentStore;
    private final List<RequiredDocumentsByCategory> requiredDocumentsByCategory;
    private final ReleaseMode releaseMode;
    private Composite mainPanel = null;
    private Composite confirmUploadPanel = null;
    private Button confirmUploadBtn = null;
    private TableViewer docsTableViewer = null;
    private Button editBtn = null;
    private Button delBtn = null;
    private Button previewBtn = null;
    private Label docsTotalSizeLbl = null;

    public UserDocumentsDialog(@Nullable Shell parentShell, @Nonnull FSDocumentStore documentStore, @Nonnull List<RequiredDocumentsByCategory> categories, @Nullable ReleaseMode releaseMode) {
        super(parentShell);
        Objects.requireNonNull(documentStore, "Document store cannot be null.");
        Objects.requireNonNull(categories, "Resolved categories list cannot be null.");
        this.documentStore = documentStore;
        this.requiredDocumentsByCategory = categories;
        this.releaseMode = releaseMode;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.translate((String)"documents.dialog.title", (Object[])new Object[0]));
        int windowsWidth = 800;
        int windowsHeight = 800;
        newShell.setMinimumSize(800, 800);
        newShell.setSize(800, 800);
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        Composite mainArea = new Composite(parent, 0);
        mainArea.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        mainArea.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(1).equalWidth(true).create());
        SashForm sash = new SashForm(mainArea, 512);
        sash.setBackground(Display.getCurrent().getSystemColor(15));
        sash.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 4).grab(true, true).create());
        Composite resolvedCatPanel = new Composite((Composite)sash, 0);
        resolvedCatPanel.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(1).equalWidth(true).create());
        resolvedCatPanel.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        final ScrolledComposite scrollPanel = new ScrolledComposite(resolvedCatPanel, 2560);
        scrollPanel.setLayoutData((Object)GridDataFactory.fillDefaults().minSize(-1, 100).grab(true, true).indent(0, 5).create());
        scrollPanel.addListener(26, e -> scrollPanel.setFocus());
        final Composite resolvedCatTablePanel = new Composite((Composite)scrollPanel, 0);
        scrollPanel.setContent((Control)resolvedCatTablePanel);
        resolvedCatTablePanel.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(1).spacing(0, 0).equalWidth(false).margins(0, 0).create());
        resolvedCatTablePanel.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        GridDataFactory categoryHeaderGdFty = GridDataFactory.swtDefaults().align(4, 1024).grab(true, true);
        GridDataFactory cellGdFty = GridDataFactory.fillDefaults().align(4, 128).grab(true, false);
        for (RequiredDocumentsByCategory category : this.requiredDocumentsByCategory) {
            Composite catRowCell = new Composite(resolvedCatTablePanel, 0);
            Color categoryRowColor = category.getLevel() == 0 ? catRowCell.getBackground() : GeResources.Color.WHITE.get();
            catRowCell.setLayout((Layout)new GridLayout());
            catRowCell.setLayoutData((Object)cellGdFty.create());
            catRowCell.setBackground(categoryRowColor);
            Label catLbl = new Label(catRowCell, 0);
            catLbl.setText(category.getLabel());
            catLbl.setFont(GeResources.Font.CATEGORY_HEADER.get());
            catLbl.setLayoutData((Object)categoryHeaderGdFty.create());
            catLbl.setBackground(categoryRowColor);
            categoryHeaderGdFty.indent(0, 1);
            Composite docsPanel = new Composite(resolvedCatTablePanel, 0);
            docsPanel.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(1).margins(0, 0).equalWidth(false).extendedMargins(0, 0, 0, 0).spacing(1, 1).create());
            docsPanel.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
            docsPanel.setBackground(GeResources.Color.GRAY_BORDER.get());
            GridDataFactory docGdfFty = cellGdFty.copy().grab(true, false);
            boolean odd = true;
            for (RequiredDocument doc : category.getDocs()) {
                Composite docRowCell = new Composite(docsPanel, 0);
                docRowCell.setLayout((Layout)new GridLayout());
                docRowCell.setLayoutData((Object)docGdfFty.create());
                docRowCell.setBackground(odd ? GeResources.Color.ODD_ROW.get() : GeResources.Color.EVEN_ROW.get());
                Label docLbl = new Label(docRowCell, 64);
                docLbl.setBackground(odd ? GeResources.Color.ODD_ROW.get() : GeResources.Color.EVEN_ROW.get());
                docLbl.setLayoutData((Object)GridDataFactory.swtDefaults().indent(5, 0).align(4, 128).grab(true, true).create());
                docLbl.setText(doc.getLabel());
                docLbl.setFont(GeResources.Font.DOCUMENT_LABEL.get());
                odd = !odd;
            }
        }
        if (this.requiredDocumentsByCategory.isEmpty()) {
            Label noResolvedDocsLbl = new Label(resolvedCatTablePanel, 0);
            noResolvedDocsLbl.setText(Messages.translate((String)"documents.dialog.resolvedCat.none", (Object[])new Object[0]));
            noResolvedDocsLbl.setFont(GeResources.Font.EMPTY_TABLE_LABEL.get());
            noResolvedDocsLbl.setLayoutData((Object)GridDataFactory.swtDefaults().align(0x1000000, 0x1000000).grab(true, true).create());
        }
        scrollPanel.setExpandVertical(true);
        scrollPanel.setExpandHorizontal(true);
        scrollPanel.setMinSize(-1, 200);
        scrollPanel.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle r = scrollPanel.getClientArea();
                scrollPanel.setMinSize(resolvedCatTablePanel.computeSize(r.width, -1));
            }
        });
        if (!this.requiredDocumentsByCategory.isEmpty() && this.releaseMode != null) {
            this.confirmUploadPanel = new Group(resolvedCatPanel, 0);
            this.confirmUploadPanel.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
            this.confirmUploadPanel.setLayout((Layout)new GridLayout(3, false));
            final Color initialBackground = this.confirmUploadPanel.getBackground();
            Image warnIcon = Display.getCurrent().getSystemImage(8);
            Image img = new Image((Device)Display.getCurrent(), warnIcon.getImageData().scaledTo(32, 32));
            this.getShell().addDisposeListener(disposeEvent -> img.dispose());
            Label confirmUploadIconLbl = new Label(this.confirmUploadPanel, 64);
            confirmUploadIconLbl.setImage(img);
            this.confirmUploadBtn = new Button(this.confirmUploadPanel, 96);
            this.confirmUploadBtn.setText(Messages.translate((String)"documents.dialog.resolvedCat.confirm", (Object[])new Object[0]));
            this.confirmUploadBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    UserDocumentsDialog.this.confirmUploadPanel.setBackground(initialBackground);
                    for (Control ctrl : UserDocumentsDialog.this.confirmUploadPanel.getChildren()) {
                        ctrl.setBackground(initialBackground);
                    }
                }
            });
            GridData layoutData = new GridData(4, 4, true, true);
            layoutData.minimumHeight = 200;
            this.confirmUploadBtn.setLayoutData((Object)layoutData);
        }
        Button resolvedCatPrintBtn = new Button(resolvedCatPanel, 8);
        resolvedCatPrintBtn.setLayoutData((Object)GridDataFactory.swtDefaults().align(131072, 0x1000000).indent(0, 5).create());
        resolvedCatPrintBtn.setText(Messages.translate((String)"documents.dialog.resolvedCat.print", (Object[])new Object[0]));
        resolvedCatPrintBtn.setToolTipText(Messages.translate((String)"documents.dialog.resolvedCat.print.tooltip", (Object[])new Object[0]));
        resolvedCatPrintBtn.setImage(GeResources.Icon.DOC_PRINT.get());
        resolvedCatPrintBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PrintRequest request = PrintUtilCD.newPrintRequest().withConfiguration(GeConstants.newPrintConfiguration()).withExpertKeys(new String[]{"Justificatifs#"});
                PrintUtilCD.printForms((PrintRequest)request);
            }
        });
        resolvedCatPrintBtn.setEnabled(!this.requiredDocumentsByCategory.isEmpty());
        this.mainPanel = mainArea;
        if (this.releaseMode == ReleaseMode.PRINT) {
            return mainArea;
        }
        Composite docsPanel = new Composite((Composite)sash, 0);
        docsPanel.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(1).equalWidth(true).create());
        docsPanel.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        Composite docsLblPanel = new Composite(docsPanel, 0);
        docsLblPanel.setLayout((Layout)new GridLayout(2, false));
        Label docsLbl = new Label(docsLblPanel, 16384);
        GridDataFactory docsLblGdFty = GridDataFactory.swtDefaults().align(0x1000000, 0x1000000);
        docsLbl.setText(Messages.translate((String)"documents.dialog.attached", (Object[])new Object[0]));
        docsLbl.setFont(GeResources.Font.DIALOG_TITLE.get());
        docsLbl.setLayoutData((Object)docsLblGdFty.create());
        Label docsInfoLbl = new Label(docsLblPanel, 16384);
        docsInfoLbl.setText(Messages.translate((String)"documents.dialog.attached.info", (Object[])new Object[0]));
        docsInfoLbl.setLayoutData((Object)docsLblGdFty.create());
        Composite docsTablePanel = new Composite(docsPanel, 0);
        docsTablePanel.setLayout((Layout)new GridLayout(1, true));
        docsTablePanel.setLayoutData((Object)GridDataFactory.fillDefaults().minSize(-1, 200).grab(true, true).indent(0, 0).create());
        this.docsTableViewer = new TableViewer(docsTablePanel, 68096);
        this.docsTableViewer.getControl().setLayoutData((Object)GridDataFactory.fillDefaults().align(4, 4).grab(true, true).create());
        TableViewerColumn catColumnViewer = new TableViewerColumn(this.docsTableViewer, 0);
        TableColumn catColumn = catColumnViewer.getColumn();
        catColumn.setText(Messages.translate((String)"documents.dialog.attached.category", (Object[])new Object[0]));
        catColumnViewer.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                UploadedDocument doc = (UploadedDocument)element;
                return Messages.translate((String)doc.getCategory().getKey(), (Object[])new Object[0]);
            }
        });
        TableViewerColumn descColumnViewer = new TableViewerColumn(this.docsTableViewer, 0);
        TableColumn descColumn = descColumnViewer.getColumn();
        descColumn.setText(Messages.translate((String)"documents.dialog.attached.description", (Object[])new Object[0]));
        descColumnViewer.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                UploadedDocument doc = (UploadedDocument)element;
                return doc.getDescription();
            }
        });
        TableViewerColumn filenameColumnViewer = new TableViewerColumn(this.docsTableViewer, 0);
        TableColumn filenameColumn = filenameColumnViewer.getColumn();
        filenameColumn.setText(Messages.translate((String)"documents.dialog.attached.filename", (Object[])new Object[0]));
        filenameColumnViewer.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                UploadedDocument doc = (UploadedDocument)element;
                return doc.getOrigFilename();
            }
        });
        this.docsTableViewer.getTable().setHeaderVisible(true);
        this.docsTableViewer.getTable().setLinesVisible(true);
        this.docsTableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        DocViewerComparator comparator = new DocViewerComparator();
        this.docsTableViewer.setComparator((ViewerComparator)comparator);
        List<UploadedDocument> docs = this.documentStore.getIndex().getDocs();
        this.docsTableViewer.setInput(docs);
        catColumn.addSelectionListener((SelectionListener)new SortListener(DocViewerComparator.Column.CATEGORY));
        catColumn.setWidth(170);
        descColumn.addSelectionListener((SelectionListener)new SortListener(DocViewerComparator.Column.DESCRIPTION));
        descColumn.setWidth(250);
        filenameColumn.addSelectionListener((SelectionListener)new SortListener(DocViewerComparator.Column.ORIGFILENAME));
        filenameColumn.setWidth(200);
        Composite docsTableBtnPanel = new Composite(docsTablePanel, 0);
        docsTableBtnPanel.setLayout((Layout)new RowLayout(256));
        Button addBtn = new Button(docsTableBtnPanel, 8);
        addBtn.setImage(GeResources.Icon.DOC_ADD.get());
        addBtn.setToolTipText(Messages.translate((String)"documents.dialog.attached.add", (Object[])new Object[0]));
        addBtn.setLayoutData((Object)new RowData(56, 32));
        addBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (UserDocumentsDialog.this.documentStore.getIndex().getDocs().size() >= 10) {
                    DialogUtil.showErrorDialog((String)"documents.dialog.error.maxFileCount", (Object[])new Object[]{10});
                    return;
                }
                new EditDocumentDialog(UserDocumentsDialog.this.getShell(), null).open();
                UserDocumentsDialog.this.reloadStoreIndex();
            }
        });
        this.editBtn = new Button(docsTableBtnPanel, 8);
        this.editBtn.setImage(GeResources.Icon.DOC_EDIT.get());
        this.editBtn.setToolTipText(Messages.translate((String)"documents.dialog.attached.edit", (Object[])new Object[0]));
        this.editBtn.setLayoutData((Object)new RowData(56, 32));
        this.editBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                IStructuredSelection selected = (IStructuredSelection)UserDocumentsDialog.this.docsTableViewer.getSelection();
                assert (!selected.isEmpty());
                UploadedDocument doc = (UploadedDocument)selected.getFirstElement();
                new EditDocumentDialog(UserDocumentsDialog.this.getShell(), doc).open();
                UserDocumentsDialog.this.reloadStoreIndex();
            }
        });
        this.previewBtn = new Button(docsTableBtnPanel, 8);
        this.previewBtn.setImage(GeResources.Icon.DOC_PREVIEW.get());
        this.previewBtn.setToolTipText(Messages.translate((String)"documents.dialog.attached.preview", (Object[])new Object[0]));
        this.previewBtn.setLayoutData((Object)new RowData(56, 32));
        this.previewBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                UserDocumentsDialog.this.previewFile((IStructuredSelection)UserDocumentsDialog.this.docsTableViewer.getSelection());
            }
        });
        this.delBtn = new Button(docsTableBtnPanel, 8);
        this.delBtn.setImage(GeResources.Icon.DOC_DELETE.get());
        this.delBtn.setToolTipText(Messages.translate((String)"documents.dialog.attached.delete", (Object[])new Object[0]));
        this.delBtn.setLayoutData((Object)new RowData(56, 32));
        this.delBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                IStructuredSelection selected = (IStructuredSelection)UserDocumentsDialog.this.docsTableViewer.getSelection();
                assert (!selected.isEmpty());
                UploadedDocument doc = (UploadedDocument)selected.getFirstElement();
                if (DialogUtil.showConfirmDialog((Shell)UserDocumentsDialog.this.getShell(), (String)"documents.dialog.attached.delete.confirm", (Object[])new Object[]{doc.getDescription()})) {
                    try {
                        LOG.debug("Deleting: {}", (Object)doc);
                        UserDocumentsDialog.this.documentStore.remove(doc);
                    }
                    catch (IOException e) {
                        LOG.error("Cannot delete attachment.", (Throwable)e);
                        DialogUtil.showErrorDialog((Shell)UserDocumentsDialog.this.getShell(), (String)"documents.dialog.attached.delete.error", (Object[])new Object[0]);
                    }
                }
                UserDocumentsDialog.this.reloadStoreIndex();
            }
        });
        docsTableBtnPanel.setLayoutData((Object)GridDataFactory.swtDefaults().align(0x1000000, 0x1000000).create());
        this.updateDocsButtons();
        Listener docsSelListener = event -> this.updateDocsButtons();
        Control ctrl = this.docsTableViewer.getControl();
        ctrl.addListener(13, docsSelListener);
        ctrl.addListener(15, docsSelListener);
        ctrl.addListener(16, docsSelListener);
        this.docsTableViewer.addDoubleClickListener(event -> this.previewFile((IStructuredSelection)event.getSelection()));
        this.docsTotalSizeLbl = new Label(mainArea, 0);
        this.reloadStoreIndex();
        DropTarget dropTarget = new DropTarget((Control)this.docsTableViewer.getTable(), 19);
        dropTarget.setTransfer(new Transfer[]{FileTransfer.getInstance()});
        dropTarget.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void drop(DropTargetEvent dropTargetEvent) {
                String[] fileList;
                FileTransfer ft = FileTransfer.getInstance();
                if (ft.isSupportedType(dropTargetEvent.currentDataType) && (fileList = (String[])dropTargetEvent.data) != null && fileList.length > 0) {
                    try {
                        Path filePath = Paths.get(fileList[0], new String[0]);
                        new EditDocumentDialog(UserDocumentsDialog.this.getShell(), null, filePath).open();
                        UserDocumentsDialog.this.reloadStoreIndex();
                        return;
                    }
                    catch (InvalidPathException e) {
                        LOG.error("Ignoring invalid file path.", (Throwable)e);
                    }
                }
                dropTargetEvent.detail = 0;
            }

            public void dragEnter(DropTargetEvent dropTargetEvent) {
                if (dropTargetEvent.detail == 16) {
                    dropTargetEvent.detail = 1;
                }
            }
        });
        sash.setWeights(new int[]{3, 2});
        mainArea.pack();
        return mainArea;
    }

    private void previewFile(IStructuredSelection selection) {
        assert (selection != null);
        if (selection.isEmpty()) {
            return;
        }
        UploadedDocument doc = (UploadedDocument)selection.getFirstElement();
        LOG.debug("Previewing: {}", (Object)doc);
        try {
            Path tmpFile = Files.createTempFile("getax_pj_preview_", ".pdf", new FileAttribute[0]);
            tmpFile.toFile().deleteOnExit();
            Files.copy(doc.getPath(), tmpFile, StandardCopyOption.REPLACE_EXISTING);
            if (!LaunchUtil.launchPdfReader((String)tmpFile.toString())) {
                DialogUtil.showErrorDialog((Shell)this.getShell(), (String)"message.acroread.failed", (Object[])new Object[0]);
            }
        }
        catch (IOException e) {
            LOG.error("Failed to create temporary preview file.", (Throwable)e);
            DialogUtil.showErrorDialog((Shell)this.getShell(), (String)"documents.dialog.attached.preview.error", (Object[])new Object[0]);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (this.releaseMode != null) {
            this.createButton(parent, 0, Messages.translate((String)"documents.dialog.continue", (Object[])new Object[0]), false);
            this.createButton(parent, 1, Messages.translate((String)"label.button.cancel", (Object[])new Object[0]), false).setFocus();
        } else {
            this.createButton(parent, 0, Messages.translate((String)"label.button.ok", (Object[])new Object[0]), true).setFocus();
        }
    }

    protected void okPressed() {
        if (this.releaseMode != null) {
            boolean oneAttachmentPresent = this.checkOneAttachmentPresent();
            if (!oneAttachmentPresent && this.releaseMode == ReleaseMode.DEPOT) {
                DialogUtil.showErrorDialog((Shell)this.getShell(), (String)"documents.dialog.attachments.missing.error", (Object[])new Object[0]);
                return;
            }
            if (this.confirmUploadBtn != null && !this.confirmUploadBtn.getSelection()) {
                DialogUtil.showErrorDialog((Shell)this.getShell(), (String)"documents.dialog.resolvedCat.confirm.error", (Object[])new Object[0]);
                this.confirmUploadPanel.setBackground(GeResources.Color.REQUIRED_FIELD.get());
                for (Control ctrl : this.confirmUploadPanel.getChildren()) {
                    ctrl.setBackground(GeResources.Color.REQUIRED_FIELD.get());
                }
                return;
            }
        }
        super.okPressed();
    }

    private void reloadStoreIndex() {
        String unit;
        FSDocumentStore.Index index = this.documentStore.getIndex();
        this.docsTableViewer.setInput(index.getDocs());
        double sizeToDisplay = index.getTotalSize();
        if (sizeToDisplay >= 1048576.0) {
            sizeToDisplay /= 1048576.0;
            unit = "Mo";
        } else {
            sizeToDisplay /= 1024.0;
            unit = "Ko";
        }
        this.docsTotalSizeLbl.setText(Messages.translate((String)"documents.dialog.attached.totalSize", (Object[])new Object[]{sizeToDisplay, unit, 100L, 10}));
        this.mainPanel.layout();
    }

    private void updateDocsButtons() {
        boolean someDocSelected = this.docsTableViewer.getControl().isFocusControl() && !this.docsTableViewer.getSelection().isEmpty();
        this.editBtn.setEnabled(someDocSelected);
        this.delBtn.setEnabled(someDocSelected);
        this.previewBtn.setEnabled(someDocSelected);
    }

    private boolean checkOneAttachmentPresent() {
        List<UploadedDocument> uploadedDocs = this.documentStore.getIndex().getDocs();
        if (this.requiredDocumentsByCategory.size() > 0) {
            return uploadedDocs.size() != 0;
        }
        return true;
    }

    private static class DocViewerComparator
    extends ViewerComparator {
        private final Collator collator = Collator.getInstance(GeConstants.DEFAULT_LOCALE);
        private boolean ascending = true;
        @Nonnull
        private Column sortColumn = Column.CATEGORY;

        private DocViewerComparator() {
        }

        void setSortColumn(@Nonnull Column sortColumn) {
            if (this.sortColumn == sortColumn) {
                this.ascending = !this.ascending;
            }
            this.sortColumn = sortColumn;
        }

        @Nonnull
        public Column getSortColumn() {
            return this.sortColumn;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            UploadedDocument doc1 = (UploadedDocument)e1;
            UploadedDocument doc2 = (UploadedDocument)e2;
            int res = switch (this.sortColumn) {
                case Column.CATEGORY -> this.collator.compare(Messages.translate((String)doc1.getCategory().getKey(), (Object[])new Object[0]), Messages.translate((String)doc2.getCategory().getKey(), (Object[])new Object[0]));
                case Column.DESCRIPTION -> this.collator.compare(doc1.getDescription(), doc2.getDescription());
                case Column.ORIGFILENAME -> this.collator.compare(doc1.getOrigFilename(), doc2.getOrigFilename());
                default -> throw new AssertionError((Object)("Unknown enum member: " + this.sortColumn));
            };
            return this.ascending ? res : -res;
        }

        static enum Column {
            CATEGORY,
            DESCRIPTION,
            ORIGFILENAME;

        }
    }

    private class SortListener
    extends SelectionAdapter {
        @Nonnull
        private final DocViewerComparator.Column sortColumn;

        SortListener(DocViewerComparator.Column sortColumn) {
            assert (sortColumn != null);
            this.sortColumn = sortColumn;
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            DocViewerComparator cmp = (DocViewerComparator)UserDocumentsDialog.this.docsTableViewer.getComparator();
            cmp.setSortColumn(this.sortColumn);
            Table table = UserDocumentsDialog.this.docsTableViewer.getTable();
            table.setSortDirection(cmp.ascending ? 128 : 1024);
            table.setSortColumn((TableColumn)selectionEvent.item);
            UserDocumentsDialog.this.docsTableViewer.refresh();
        }
    }

    private class EditDocumentDialog
    extends Dialog {
        @Nullable
        private final UploadedDocument doc;
        @Nullable
        private final Path defaultFile;
        private CLabel pathLbl;
        private Text descTxt;
        private ComboViewer catViewer;
        private Shell waitSplash;

        EditDocumentDialog(@Nullable Shell parentShell, UploadedDocument doc) {
            this(parentShell, doc, null);
        }

        EditDocumentDialog(@Nullable Shell parentShell, @Nullable UploadedDocument doc, Path defaultFile) {
            super(parentShell);
            this.pathLbl = null;
            this.descTxt = null;
            this.catViewer = null;
            this.waitSplash = null;
            this.doc = doc;
            this.defaultFile = defaultFile;
        }

        protected Control createDialogArea(Composite parent) {
            Composite mainArea = new Composite(parent, 0);
            mainArea.setLayout((Layout)new GridLayout(3, false));
            Group fileGrp = new Group(mainArea, 0);
            fileGrp.setLayout((Layout)new GridLayout(2, false));
            GeResources.setBoldFont((Control)fileGrp);
            if (this.doc == null) {
                fileGrp.setText(Messages.translate((String)"documents.dialog.attached.editor.add", (Object[])new Object[0]));
                this.pathLbl = new CLabel((Composite)fileGrp, 2052);
                this.pathLbl.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
                this.pathLbl.setEnabled(false);
                Button browseBtn = new Button((Composite)fileGrp, 8);
                browseBtn.setText(Messages.translate((String)"documents.dialog.attached.editor.add.browse", (Object[])new Object[0]));
                browseBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent selectionEvent) {
                        FileDialog fileDlg = new FileDialog(EditDocumentDialog.this.getShell(), 4096);
                        fileDlg.setFilterExtensions(new String[]{"*.pdf", "*.*"});
                        fileDlg.setFilterNames(new String[]{Messages.translate((String)"documents.dialog.attached.editor.ext.pdf", (Object[])new Object[0]), Messages.translate((String)"documents.dialog.attached.editor.ext.all", (Object[])new Object[0])});
                        String filePath = fileDlg.open();
                        if (filePath == null) {
                            return;
                        }
                        EditDocumentDialog.this.pathLbl.setText(filePath);
                        EditDocumentDialog.this.updateOKBtn();
                    }
                });
                Label pdfLbl = new Label((Composite)fileGrp, 0);
                pdfLbl.setText(Messages.translate((String)"documents.dialog.attached.editor.add.notice", (Object[])new Object[0]));
                pdfLbl.setLayoutData((Object)GridDataFactory.swtDefaults().span(2, 1).create());
            } else {
                fileGrp.setText(Messages.translate((String)"documents.dialog.attached.editor.edit", (Object[])new Object[0]));
                fileGrp.setLayout((Layout)new GridLayout(2, false));
                Label nameLbl = new Label((Composite)fileGrp, 0);
                nameLbl.setText(Messages.translate((String)"documents.dialog.attached.editor.edit.filename", (Object[])new Object[0]));
                CLabel filenameLabel = new CLabel((Composite)fileGrp, 2052);
                filenameLabel.setText(this.doc.getOrigFilename());
                filenameLabel.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
            }
            fileGrp.setLayoutData((Object)GridDataFactory.fillDefaults().span(3, 1).grab(true, false).create());
            Group catGrp = new Group(mainArea, 0);
            catGrp.setLayout((Layout)new GridLayout(2, false));
            GeResources.setBoldFont((Control)catGrp);
            catGrp.setText(Messages.translate((String)"documents.dialog.attached.editor.category", (Object[])new Object[0]));
            this.catViewer = new ComboViewer((Composite)catGrp, 8);
            this.catViewer.getControl().setLayoutData((Object)GridDataFactory.swtDefaults().span(2, 1).create());
            ArrayList<UploadedDocumentType> inputs = new ArrayList<UploadedDocumentType>(Arrays.asList(UploadedDocumentType.values()));
            final Object emptyChoice = new Object();
            if (this.doc == null) {
                inputs.add(0, (UploadedDocumentType)((Object)emptyChoice));
            }
            this.catViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    if (emptyChoice.equals(element)) {
                        return Messages.translate((String)"documents.dialog.attached.editor.category.choose", (Object[])new Object[0]);
                    }
                    return Messages.translate((String)((UploadedDocumentType)((Object)element)).getKey(), (Object[])new Object[0]);
                }
            });
            this.catViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            this.catViewer.setInput(inputs);
            this.catViewer.setSelection((ISelection)new StructuredSelection(this.doc != null ? this.doc.getCategory() : emptyChoice));
            catGrp.setLayoutData((Object)GridDataFactory.fillDefaults().span(3, 1).grab(true, false).create());
            Group descGrp = new Group(mainArea, 0);
            descGrp.setLayout((Layout)new GridLayout(2, false));
            GeResources.setBoldFont((Control)descGrp);
            descGrp.setText(Messages.translate((String)"documents.dialog.attached.editor.description", (Object[])new Object[0]));
            this.descTxt = new Text((Composite)descGrp, 0);
            this.descTxt.setTextLimit(50);
            this.descTxt.setLayoutData((Object)GridDataFactory.fillDefaults().span(2, 1).grab(true, false).create());
            if (this.doc != null) {
                this.descTxt.setText(this.doc.getDescription());
            }
            descGrp.setLayoutData((Object)GridDataFactory.fillDefaults().span(3, 1).grab(true, false).create());
            Label noticeLbl = new Label(mainArea, 0);
            noticeLbl.setText(Messages.translate((String)"documents.dialog.attached.editor.notice", (Object[])new Object[]{40L}));
            noticeLbl.setLayoutData((Object)GridDataFactory.swtDefaults().align(0x1000000, 0x1000000).span(3, 1).create());
            if (this.doc == null) {
                Link docsHelpLnk = new Link(mainArea, 0);
                docsHelpLnk.setText(Messages.translate((String)"documents.dialog.attached.editor.add.help", (Object[])new Object[0]));
                docsHelpLnk.setLayoutData((Object)GridDataFactory.swtDefaults().align(131072, 0x1000000).span(3, 1).create());
                docsHelpLnk.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        HelpMainhelpAction help = new HelpMainhelpAction(EditDocumentDialog.this.getShell(), event.text);
                        help.run();
                    }
                });
            }
            Listener changeListener = event -> this.updateOKBtn();
            if (this.pathLbl != null) {
                this.pathLbl.addListener(24, changeListener);
                if (this.defaultFile != null) {
                    this.pathLbl.setText(this.defaultFile.toString());
                }
            }
            this.descTxt.addListener(24, changeListener);
            this.catViewer.getCombo().addListener(24, changeListener);
            return mainArea;
        }

        protected void okPressed() {
            if (!this.isReady()) {
                return;
            }
            assert (this.descTxt != null && this.descTxt.getText() != null && !this.descTxt.getText().isEmpty());
            final String desc = this.descTxt.getText();
            IStructuredSelection selected = (IStructuredSelection)this.catViewer.getSelection();
            assert (!selected.isEmpty());
            final UploadedDocumentType category = (UploadedDocumentType)((Object)selected.getFirstElement());
            this.waitSplash = new Shell(this.getShell(), 65536);
            Rectangle dialogBounds = this.getShell().getBounds();
            this.waitSplash.setLayout((Layout)new GridLayout(1, true));
            Label waitLbl = new Label((Composite)this.waitSplash, 0);
            waitLbl.setText(Messages.translate((String)"documents.dialog.attached.editor.wait", (Object[])new Object[0]));
            waitLbl.setLayoutData((Object)GridDataFactory.swtDefaults().align(0x1000000, 0x1000000).grab(true, true).create());
            this.waitSplash.pack();
            Rectangle splashRect = this.waitSplash.getBounds();
            int x = dialogBounds.x + (dialogBounds.width - splashRect.width) / 2;
            int y = dialogBounds.y + (dialogBounds.height - splashRect.height) / 2;
            this.waitSplash.setLocation(x, y);
            this.waitSplash.open();
            ExecutorService executor = Executors.newSingleThreadExecutor();
            executor.submit(new Callable<Void>(){
                private String error = null;
                private Object[] errorArgs = null;

                @Override
                @Nullable
                public Void call() throws Exception {
                    boolean newFile = EditDocumentDialog.this.doc == null;
                    try {
                        if (newFile) {
                            assert (EditDocumentDialog.this.pathLbl != null && EditDocumentDialog.this.pathLbl.getText() != null && !EditDocumentDialog.this.pathLbl.getText().isEmpty());
                            Path newDocumentPath = Paths.get(EditDocumentDialog.this.pathLbl.getText(), new String[0]);
                            try {
                                UserDocumentsDialog.this.documentStore.addFile(newDocumentPath, category, desc);
                            }
                            catch (DocSizeLimitExceededException ignored) {
                                this.error = "documents.dialog.attached.editor.add.error.fileSize";
                                this.errorArgs = new Object[]{40L};
                            }
                            catch (StoreSizeLimitExceededException ignored) {
                                this.error = "documents.dialog.attached.editor.add.error.storeSize";
                                this.errorArgs = new Object[]{100L};
                            }
                            catch (UnsupportedDocFormatException e) {
                                LOG.error("Failed to interpret provided document as PDF.", (Throwable)e);
                                this.error = "documents.dialog.attached.editor.add.error.pdf";
                            }
                            catch (DocAlreadyStoredException ignored) {
                                this.error = "documents.dialog.attached.editor.add.error.duplicate";
                            }
                        } else {
                            UserDocumentsDialog.this.documentStore.update(EditDocumentDialog.this.doc, category, desc);
                        }
                    }
                    catch (Exception e) {
                        LOG.error("Failed to store provided document.", (Throwable)e);
                        this.error = "documents.dialog.attached.editor.add.error.io";
                    }
                    Display.getDefault().asyncExec(() -> {
                        EditDocumentDialog.this.waitSplash.close();
                        if (this.error != null) {
                            DialogUtil.showErrorDialog((Shell)EditDocumentDialog.this.getShell(), (String)this.error, (Object[])this.errorArgs);
                        } else {
                            EditDocumentDialog.super.okPressed();
                        }
                    });
                    return null;
                }
            });
            executor.shutdown();
        }

        protected Control createContents(Composite parent) {
            Control ctrl = super.createContents(parent);
            this.updateOKBtn();
            return ctrl;
        }

        boolean isReady() {
            boolean ready;
            IStructuredSelection selected = (IStructuredSelection)this.catViewer.getSelection();
            if (selected.isEmpty()) {
                return false;
            }
            Object value = selected.getFirstElement();
            if (!(value instanceof UploadedDocumentType)) {
                return false;
            }
            String desc = this.descTxt.getText();
            boolean bl = ready = desc != null && !desc.isEmpty();
            if (ready && this.pathLbl != null) {
                String path = this.pathLbl.getText();
                ready = path != null && !path.isEmpty();
            }
            return ready;
        }

        void updateOKBtn() {
            this.getButton(0).setEnabled(this.isReady());
        }
    }
}

